/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ReusableMessageFactory;
import org.apache.logging.log4j.message.ReusableParameterizedMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReusableMessageFactoryTest {
    @Test
    public void testCreateEventReturnsDifferentInstanceIfNotReleased() throws Exception {
        ReusableMessageFactory factory = new ReusableMessageFactory();
        Message message1 = factory.newMessage("text, p0={} p1={} p2={} p3={}", (Object)1, (Object)2, (Object)3, (Object)4);
        Message message2 = factory.newMessage("text, p0={} p1={} p2={} p3={}", (Object)9, (Object)8, (Object)7, (Object)6);
        Assertions.assertNotSame((Object)message1, (Object)message2);
        ReusableMessageFactory.release((Message)message1);
        ReusableMessageFactory.release((Message)message2);
    }

    @Test
    public void testCreateEventReturnsSameInstance() throws Exception {
        ReusableMessageFactory factory = new ReusableMessageFactory();
        Message message1 = factory.newMessage("text, p0={} p1={} p2={} p3={}", (Object)1, (Object)2, (Object)3, (Object)4);
        ReusableMessageFactory.release((Message)message1);
        Message message2 = factory.newMessage("text, p0={} p1={} p2={} p3={}", (Object)9, (Object)8, (Object)7, (Object)6);
        Assertions.assertSame((Object)message1, (Object)message2);
        ReusableMessageFactory.release((Message)message2);
        Message message3 = factory.newMessage("text, AAA={} BBB={} p2={} p3={}", (Object)9, (Object)8, (Object)7, (Object)6);
        Assertions.assertSame((Object)message2, (Object)message3);
        ReusableMessageFactory.release((Message)message3);
    }

    private void assertReusableParameterizeMessage(Message message, String txt, Object[] params) {
        Assertions.assertTrue((boolean)(message instanceof ReusableParameterizedMessage));
        ReusableParameterizedMessage msg = (ReusableParameterizedMessage)message;
        Assertions.assertTrue((boolean)msg.reserved, (String)"reserved");
        Assertions.assertEquals((Object)txt, (Object)msg.getFormat());
        Assertions.assertEquals((int)msg.getParameterCount(), (int)params.length, (String)"count");
        Object[] messageParams = msg.getParameters();
        for (int i = 0; i < params.length; ++i) {
            Assertions.assertEquals((Object)messageParams[i], (Object)params[i]);
        }
    }

    @Test
    public void testCreateEventOverwritesFields() throws Exception {
        ReusableMessageFactory factory = new ReusableMessageFactory();
        Message message1 = factory.newMessage("text, p0={} p1={} p2={} p3={}", (Object)1, (Object)2, (Object)3, (Object)4);
        this.assertReusableParameterizeMessage(message1, "text, p0={} p1={} p2={} p3={}", new Object[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4)});
        ReusableMessageFactory.release((Message)message1);
        Message message2 = factory.newMessage("other, A={} B={} C={} D={}", (Object)1, (Object)2, (Object)3, (Object)4);
        this.assertReusableParameterizeMessage(message1, "other, A={} B={} C={} D={}", new Object[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4)});
        Assertions.assertSame((Object)message1, (Object)message2);
        ReusableMessageFactory.release((Message)message2);
    }

    @Test
    public void testCreateEventReturnsThreadLocalInstance() throws Exception {
        final ReusableMessageFactory factory = new ReusableMessageFactory();
        final AtomicReference message1 = new AtomicReference();
        final AtomicReference message2 = new AtomicReference();
        Thread t1 = new Thread("THREAD 1"){

            @Override
            public void run() {
                message1.set(factory.newMessage("text, p0={} p1={} p2={} p3={}", (Object)1, (Object)2, (Object)3, (Object)4));
            }
        };
        Thread t2 = new Thread("Thread 2"){

            @Override
            public void run() {
                message2.set(factory.newMessage("other, A={} B={} C={} D={}", (Object)1, (Object)2, (Object)3, (Object)4));
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        Assertions.assertNotNull(message1.get());
        Assertions.assertNotNull(message2.get());
        Assertions.assertNotSame(message1.get(), message2.get());
        this.assertReusableParameterizeMessage((Message)message1.get(), "text, p0={} p1={} p2={} p3={}", new Object[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4)});
        this.assertReusableParameterizeMessage((Message)message2.get(), "other, A={} B={} C={} D={}", new Object[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4)});
        ReusableMessageFactory.release((Message)((Message)message1.get()));
        ReusableMessageFactory.release((Message)((Message)message2.get()));
    }
}

