/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import org.apache.logging.log4j.message.ReusableObjectMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReusableObjectMessageTest {
    @Test
    public void testSet_InitializesFormattedMessage() throws Exception {
        ReusableObjectMessage msg = new ReusableObjectMessage();
        msg.set((Object)"abc");
        Assertions.assertEquals((Object)"abc", (Object)msg.getFormattedMessage());
    }

    @Test
    public void testGetFormattedMessage_InitiallyNullString() throws Exception {
        Assertions.assertEquals((Object)"null", (Object)new ReusableObjectMessage().getFormattedMessage());
    }

    @Test
    public void testGetFormattedMessage_ReturnsLatestSetString() throws Exception {
        ReusableObjectMessage msg = new ReusableObjectMessage();
        msg.set((Object)"abc");
        Assertions.assertEquals((Object)"abc", (Object)msg.getFormattedMessage());
        msg.set((Object)"def");
        Assertions.assertEquals((Object)"def", (Object)msg.getFormattedMessage());
        msg.set((Object)"xyz");
        Assertions.assertEquals((Object)"xyz", (Object)msg.getFormattedMessage());
    }

    @Test
    public void testGetFormat_InitiallyNull() throws Exception {
        Assertions.assertNull((Object)new ReusableObjectMessage().getFormat());
    }

    @Test
    public void testGetFormat_ReturnsLatestSetString() throws Exception {
        ReusableObjectMessage msg = new ReusableObjectMessage();
        msg.set((Object)"abc");
        Assertions.assertEquals((Object)"abc", (Object)msg.getFormat());
        msg.set((Object)"def");
        Assertions.assertEquals((Object)"def", (Object)msg.getFormat());
        msg.set((Object)"xyz");
        Assertions.assertEquals((Object)"xyz", (Object)msg.getFormat());
    }

    @Test
    public void testGetParameters_InitiallyReturnsNullObjectInLength1Array() throws Exception {
        Assertions.assertArrayEquals((Object[])new Object[]{null}, (Object[])new ReusableObjectMessage().getParameters());
    }

    @Test
    public void testGetParameters_ReturnsSetObjectInParameterArrayAfterMessageSet() throws Exception {
        ReusableObjectMessage msg = new ReusableObjectMessage();
        msg.set((Object)"abc");
        Assertions.assertArrayEquals((Object[])new Object[]{"abc"}, (Object[])msg.getParameters());
        msg.set((Object)"def");
        Assertions.assertArrayEquals((Object[])new Object[]{"def"}, (Object[])msg.getParameters());
    }

    @Test
    public void testGetThrowable_InitiallyReturnsNull() throws Exception {
        Assertions.assertNull((Object)new ReusableObjectMessage().getThrowable());
    }

    @Test
    public void testGetThrowable_ReturnsNullAfterMessageSet() throws Exception {
        ReusableObjectMessage msg = new ReusableObjectMessage();
        msg.set((Object)"abc");
        Assertions.assertNull((Object)msg.getThrowable());
        msg.set((Object)"def");
        Assertions.assertNull((Object)msg.getThrowable());
    }

    @Test
    public void testFormatTo_InitiallyWritesNull() throws Exception {
        ReusableObjectMessage msg = new ReusableObjectMessage();
        StringBuilder sb = new StringBuilder();
        msg.formatTo(sb);
        Assertions.assertEquals((Object)"null", (Object)sb.toString());
    }

    @Test
    public void testFormatTo_WritesLatestSetString() throws Exception {
        ReusableObjectMessage msg = new ReusableObjectMessage();
        StringBuilder sb = new StringBuilder();
        msg.formatTo(sb);
        Assertions.assertEquals((Object)"null", (Object)sb.toString());
        sb.setLength(0);
        msg.set((Object)"abc");
        msg.formatTo(sb);
        Assertions.assertEquals((Object)"abc", (Object)sb.toString());
        sb.setLength(0);
        msg.set((Object)"def");
        msg.formatTo(sb);
        Assertions.assertEquals((Object)"def", (Object)sb.toString());
        sb.setLength(0);
        msg.set((Object)"xyz");
        msg.formatTo(sb);
        Assertions.assertEquals((Object)"xyz", (Object)sb.toString());
    }
}

