/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.metadata.translatable;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.shardingsphere.sqlfederation.optimizer.metadata.translatable.TranslatableTableScan;

public class TranslatableProjectFilterRule
extends RelOptRule {
    public static final TranslatableProjectFilterRule INSTANCE = new TranslatableProjectFilterRule(RelFactories.LOGICAL_BUILDER);

    public TranslatableProjectFilterRule(RelBuilderFactory relBuilderFactory) {
        super(TranslatableProjectFilterRule.operand(LogicalProject.class, (RelOptRuleOperand)TranslatableProjectFilterRule.operand(LogicalFilter.class, (RelOptRuleOperand)TranslatableProjectFilterRule.operand(TranslatableTableScan.class, (RelOptRuleOperandChildren)TranslatableProjectFilterRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, "TranslatableProjectFilterRule");
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalProject project = (LogicalProject)call.rel(0);
        LogicalFilter filter = (LogicalFilter)call.rel(1);
        TranslatableTableScan scan = (TranslatableTableScan)call.rel(2);
        int[] fields = this.getProjectFields(project.getProjects());
        if (null == fields) {
            return;
        }
        call.transformTo((RelNode)new TranslatableTableScan(scan.getCluster(), scan.getTable(), scan.getTranslatableTable(), Collections.singletonList(filter.getCondition()), fields));
    }

    private int[] getProjectFields(List<RexNode> rexNodes) {
        int[] result = new int[rexNodes.size()];
        for (int index = 0; index < rexNodes.size(); ++index) {
            RexNode exp = rexNodes.get(index);
            if (!(exp instanceof RexInputRef)) {
                return null;
            }
            result[index] = ((RexInputRef)exp).getIndex();
        }
        return result;
    }
}

