/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tephra.hbase.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.tephra.hbase.coprocessor.TransactionProcessor;

public class FilteredInternalScanner
implements InternalScanner {
    private final InternalScanner delegate;
    private final Filter filter;
    private List<Cell> outResult = new ArrayList<Cell>();

    public FilteredInternalScanner(InternalScanner internalScanner, TransactionProcessor.IncludeInProgressFilter filter) {
        this.delegate = internalScanner;
        this.filter = filter;
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
        this.outResult.clear();
        if (this.filter.filterAllRemaining()) {
            return false;
        }
        do {
            boolean next = this.delegate.next(this.outResult, scannerContext);
            for (Cell cell : this.outResult) {
                Filter.ReturnCode code = this.filter.filterKeyValue(cell);
                switch (code) {
                    case INCLUDE: 
                    case INCLUDE_AND_NEXT_COL: {
                        result.add(cell);
                        break;
                    }
                }
            }
            if (next) continue;
            return next;
        } while (result.isEmpty());
        return true;
    }
}

