/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.BaseMapper;
import org.codehaus.jackson.map.JsonSerializerFactory;
import org.codehaus.jackson.map.JsonSerializerProvider;
import org.codehaus.jackson.map.legacy.LegacyJavaTypeMapper;
import org.codehaus.jackson.map.ser.BeanSerializerFactory;
import org.codehaus.jackson.map.ser.StdSerializerProvider;

public class JavaTypeMapper
extends BaseMapper {
    protected final JsonFactory _jsonFactory;
    protected JsonSerializerProvider _serializerProvider;
    protected JsonSerializerFactory _serializerFactory;
    static final LegacyJavaTypeMapper _legacyMapper = new LegacyJavaTypeMapper();

    public JavaTypeMapper() {
        this(null);
    }

    public JavaTypeMapper(JsonFactory jf) {
        this(jf, null);
    }

    public JavaTypeMapper(JsonFactory jf, JsonSerializerProvider sp) {
        this(jf, sp, null);
    }

    public JavaTypeMapper(JsonFactory jf, JsonSerializerProvider p, JsonSerializerFactory jsf) {
        this._jsonFactory = jf == null ? new JsonFactory() : jf;
        this._serializerProvider = p == null ? new StdSerializerProvider() : p;
        this._serializerFactory = jsf == null ? BeanSerializerFactory.instance : jsf;
    }

    public void setSerializerFactory(JsonSerializerFactory f) {
        this._serializerFactory = f;
    }

    public void setSerializerProvider(JsonSerializerProvider p) {
        this._serializerProvider = p;
    }

    public Object read(JsonParser jp) throws IOException, JsonParseException {
        JsonToken curr = jp.getCurrentToken();
        if (curr == null && (curr = jp.nextToken()) == null) {
            return null;
        }
        Object result = this._readAndMap(jp, curr);
        jp.nextToken();
        return result;
    }

    public final void writeValue(JsonGenerator jgen, Object value) throws IOException, JsonGenerationException {
        this._serializerProvider.serializeValue(jgen, value, this._serializerFactory);
        jgen.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeValue(File resultFile, Object value) throws IOException, JsonGenerationException {
        JsonGenerator jgen = this._jsonFactory.createJsonGenerator(resultFile, JsonEncoding.UTF8);
        boolean closed = false;
        try {
            this.writeValue(jgen, value);
            closed = true;
            jgen.close();
        }
        finally {
            if (!closed) {
                try {
                    jgen.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeValue(OutputStream out, Object value) throws IOException, JsonGenerationException {
        JsonGenerator jgen = this._jsonFactory.createJsonGenerator(out, JsonEncoding.UTF8);
        boolean closed = false;
        try {
            this.writeValue(jgen, value);
            closed = true;
            jgen.close();
        }
        finally {
            if (!closed) {
                jgen.close();
            }
        }
    }

    public final void writeAny(JsonGenerator jg, Object value) throws IOException, JsonGenerationException {
        _legacyMapper.writeAny(jg, value);
        jg.flush();
    }

    protected Object _readAndMap(JsonParser jp, JsonToken currToken) throws IOException, JsonParseException {
        switch (currToken) {
            case START_OBJECT: {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                while ((currToken = jp.nextToken()) != JsonToken.END_OBJECT) {
                    if (currToken != JsonToken.FIELD_NAME) {
                        this._reportProblem(jp, "Unexpected token (" + (Object)((Object)currToken) + "), expected FIELD_NAME");
                    }
                    String fieldName = jp.getText();
                    Object value = this._readAndMap(jp, jp.nextToken());
                    if (this._cfgDupFields == BaseMapper.DupFields.ERROR) {
                        Object old = result.put(fieldName, value);
                        if (old == null) continue;
                        this._reportProblem(jp, "Duplicate value for field '" + fieldName + "', when dup fields mode is " + (Object)((Object)this._cfgDupFields));
                        continue;
                    }
                    if (this._cfgDupFields == BaseMapper.DupFields.USE_LAST) {
                        result.put(fieldName, value);
                        continue;
                    }
                    if (result.containsKey(fieldName)) continue;
                    result.put(fieldName, value);
                }
                return result;
            }
            case START_ARRAY: {
                ArrayList<Object> result = new ArrayList<Object>();
                while ((currToken = jp.nextToken()) != JsonToken.END_ARRAY) {
                    Object value = this._readAndMap(jp, currToken);
                    result.add(value);
                }
                return result;
            }
            case VALUE_STRING: {
                return jp.getText();
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return jp.getNumberValue();
            }
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
            case VALUE_NULL: {
                return null;
            }
            case FIELD_NAME: 
            case END_OBJECT: 
            case END_ARRAY: {
                this._reportProblem(jp, "Can not map token " + (Object)((Object)currToken) + ": stream off by a token or two?");
            }
        }
        this._throwInternal("Unrecognized event type: " + (Object)((Object)currToken));
        return null;
    }
}

