/*
 * Decompiled with CFR 0.152.
 */
package org.digitalforge.log4jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.digitalforge.log4jdbc.LoggingConnection;
import org.digitalforge.log4jdbc.LoggingDriverConfig;
import org.digitalforge.log4jdbc.SpyLogDelegator;
import org.digitalforge.log4jdbc.SpyLogFactory;
import org.digitalforge.log4jdbc.formatter.MySqlParameterFormatter;
import org.digitalforge.log4jdbc.formatter.OracleParameterFormatter;
import org.digitalforge.log4jdbc.formatter.ParameterFormatter;
import org.digitalforge.log4jdbc.formatter.SqlQueryPrettifier;
import org.digitalforge.log4jdbc.formatter.SqlServerParameterFormatter;

public class LoggingDriver
implements Driver {
    private Driver lastUnderlyingDriverRequested;
    private static final SpyLogDelegator log = SpyLogFactory.getSpyLogDelegator();
    public static SqlQueryPrettifier sqlPrettifier;
    static LoggingDriverConfig config;
    static ParameterFormatter defaultParameterFormatter;

    static ParameterFormatter getRdbmsSpecifics(Connection con) {
        String driverName = null;
        try {
            driverName = con.getMetaData().getDriverName();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        log.debug("Driver name is " + driverName);
        ParameterFormatter formatter = config.getParameterFormatter(driverName);
        return formatter;
    }

    @Override
    public int getMajorVersion() {
        return this.lastUnderlyingDriverRequested != null ? this.lastUnderlyingDriverRequested.getMajorVersion() : 1;
    }

    @Override
    public int getMinorVersion() {
        return this.lastUnderlyingDriverRequested != null ? this.lastUnderlyingDriverRequested.getMinorVersion() : 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return this.lastUnderlyingDriverRequested != null && this.lastUnderlyingDriverRequested.jdbcCompliant();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.lastUnderlyingDriverRequested != null ? this.lastUnderlyingDriverRequested.getParentLogger() : null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        Driver driver = this.getUnderlyingDriver(url);
        if (driver == null) {
            return false;
        }
        this.lastUnderlyingDriverRequested = driver;
        return true;
    }

    private Driver getUnderlyingDriver(String url) throws SQLException {
        if (!url.startsWith("jdbc:log4")) {
            return null;
        }
        url = url.substring(9);
        Enumeration<Driver> e = DriverManager.getDrivers();
        while (e.hasMoreElements()) {
            Driver driver = e.nextElement();
            if (driver.getClass() == LoggingDriver.class || !driver.acceptsURL(url)) continue;
            return driver;
        }
        return null;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Driver driver = this.getUnderlyingDriver(url);
        if (driver == null) {
            return null;
        }
        this.lastUnderlyingDriverRequested = driver;
        Connection con = driver.connect(url = url.substring(9), info);
        if (con == null) {
            throw new SQLException("Invalid or unknown driver url: " + url);
        }
        if (!log.isJdbcLoggingEnabled()) {
            return con;
        }
        LoggingConnection logcon = new LoggingConnection(con);
        ParameterFormatter formatter = null;
        String dclass = driver.getClass().getName();
        if (dclass != null && !dclass.isEmpty()) {
            formatter = config.getParameterFormatter(dclass);
        }
        if (formatter == null) {
            formatter = defaultParameterFormatter;
        }
        logcon.setParameterFormatter(formatter);
        return logcon;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Driver driver = this.getUnderlyingDriver(url);
        if (driver == null) {
            return new DriverPropertyInfo[0];
        }
        this.lastUnderlyingDriverRequested = driver;
        url = url.substring(9);
        return driver.getPropertyInfo(url, info);
    }

    static {
        log.debug("... Log4JDBC initializing ...");
        config = new LoggingDriverConfig();
        sqlPrettifier = new SqlQueryPrettifier(){

            @Override
            public String prettifySql(String sql) {
                return sql;
            }
        };
        TreeSet<String> subDrivers = new TreeSet<String>();
        if (config.isAutoLoadPopularDrivers()) {
            subDrivers.add("com.mysql.cj.jdbc.Driver");
            subDrivers.add("org.mariadb.jdbc.Driver");
            subDrivers.add("org.postgresql.Driver");
            subDrivers.add("org.hsqldb.jdbcDriver");
            subDrivers.add("org.h2.Driver");
        }
        for (String driver : config.getDrivers()) {
            subDrivers.add(driver);
            log.debug("    will look for specific driver " + driver);
        }
        try {
            DriverManager.registerDriver(new LoggingDriver());
        }
        catch (SQLException ex) {
            throw new RuntimeException("Could not register Log4JDBC driver!", ex);
        }
        Iterator itr = subDrivers.iterator();
        while (itr.hasNext()) {
            String driverClass = (String)itr.next();
            try {
                Class.forName(driverClass);
                log.debug("FOUND DRIVER " + driverClass);
            }
            catch (Throwable c) {
                itr.remove();
            }
        }
        if (subDrivers.isEmpty()) {
            log.debug("WARNING!  Log4JDBC couldn't find any underlying jdbc drivers.");
        }
        SqlServerParameterFormatter sqlServer = new SqlServerParameterFormatter();
        OracleParameterFormatter oracle = new OracleParameterFormatter();
        MySqlParameterFormatter mySql = new MySqlParameterFormatter();
        Map<String, ParameterFormatter> parameterFormatters = config.getParameterFormatters();
        parameterFormatters.put("oracle.jdbc.driver.OracleDriver", oracle);
        parameterFormatters.put("oracle.jdbc.OracleDriver", oracle);
        parameterFormatters.put("net.sourceforge.jtds.jdbc.Driver", sqlServer);
        parameterFormatters.put("com.microsoft.jdbc.sqlserver.SQLServerDriver", sqlServer);
        parameterFormatters.put("weblogic.jdbc.sqlserver.SQLServerDriver", sqlServer);
        parameterFormatters.put("com.mysql.jdbc.Driver", mySql);
        parameterFormatters.put("com.mysql.cj.jdbc.Driver", mySql);
        parameterFormatters.put("org.mariadb.jdbc.Driver", mySql);
        log.debug("... Log4JDBC initialized! ...");
        defaultParameterFormatter = new ParameterFormatter();
    }
}

