/*
 * Decompiled with CFR 0.152.
 */
package org.digitalforge.log4jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.digitalforge.log4jdbc.LoggingDriver;
import org.digitalforge.log4jdbc.formatter.ParameterFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingDriverConfig {
    private static final Logger log = LoggerFactory.getLogger(LoggingDriverConfig.class);
    private static final ParameterFormatter DEFAULT_PARAMETER_FORMATTER = new ParameterFormatter();
    private Map<String, ParameterFormatter> parameterFormatters = new HashMap<String, ParameterFormatter>();
    private String debugStackPrefix;
    private boolean traceFromApplication;
    private boolean sqlTimingWarnThresholdEnabled;
    private long sqlTimingWarnThresholdNanoSec;
    private boolean sqlTimingErrorThresholdEnabled;
    private long sqlTimingErrorThresholdNanoSec;
    private boolean dumpSqlSelect;
    private boolean dumpSqlInsert;
    private boolean dumpSqlUpdate;
    private boolean dumpSqlDelete;
    private boolean dumpSqlCreate;
    private boolean reportOriginalSql;
    private boolean shouldUseMarkersForTimingReports;
    private boolean dumpSqlFilteringOn;
    private boolean dumpFullDebugStackTrace;
    private boolean autoLoadPopularDrivers;
    private boolean trimSql;
    private List<String> drivers;

    LoggingDriverConfig() {
        Properties props = new Properties(System.getProperties());
        try (InputStream in = LoggingDriver.class.getResourceAsStream("/log4jdbc.properties");){
            props.load(in);
            log.debug("log4jdbc.properties loaded from classpath");
        }
        catch (IOException ex) {
            log.debug("Exception loading log4jdbc.properties from classpath: " + ex.getMessage());
        }
        catch (NullPointerException ex) {
            log.debug("log4jdbc.properties not found on classpath");
        }
        this.debugStackPrefix = LoggingDriverConfig.getStringOption(props, "log4jdbc.debug.stack.prefix");
        this.traceFromApplication = this.debugStackPrefix != null;
        Long thresh = LoggingDriverConfig.getLongOption(props, "log4jdbc.sqltiming.warn.threshold");
        boolean bl = this.sqlTimingWarnThresholdEnabled = thresh != null;
        if (this.sqlTimingWarnThresholdEnabled) {
            this.sqlTimingWarnThresholdNanoSec = thresh;
        }
        boolean bl2 = this.sqlTimingErrorThresholdEnabled = (thresh = LoggingDriverConfig.getLongOption(props, "log4jdbc.sqltiming.error.threshold")) != null;
        if (this.sqlTimingErrorThresholdEnabled) {
            this.sqlTimingErrorThresholdNanoSec = thresh;
        }
        this.shouldUseMarkersForTimingReports = LoggingDriverConfig.getBooleanOption(props, "log4jdbc.sqltiming.usemarkersfortimingreports", false);
        this.dumpFullDebugStackTrace = LoggingDriverConfig.getBooleanOption(props, "log4jdbc.dump.fulldebugstacktrace", false);
        this.dumpSqlSelect = LoggingDriverConfig.getBooleanOption(props, "log4jdbc.dump.sql.select", true);
        this.dumpSqlInsert = LoggingDriverConfig.getBooleanOption(props, "log4jdbc.dump.sql.insert", true);
        this.dumpSqlUpdate = LoggingDriverConfig.getBooleanOption(props, "log4jdbc.dump.sql.update", true);
        this.dumpSqlDelete = LoggingDriverConfig.getBooleanOption(props, "log4jdbc.dump.sql.delete", true);
        this.dumpSqlCreate = LoggingDriverConfig.getBooleanOption(props, "log4jdbc.dump.sql.create", true);
        this.reportOriginalSql = LoggingDriverConfig.getBooleanOption(props, "log4jdbc.dump.sql.reportoriginal", false);
        this.dumpSqlFilteringOn = !this.dumpSqlSelect || !this.dumpSqlInsert || !this.dumpSqlUpdate || !this.dumpSqlDelete || !this.dumpSqlCreate;
        this.autoLoadPopularDrivers = LoggingDriverConfig.getBooleanOption(props, "log4jdbc.auto.load.popular.drivers", true);
        this.trimSql = LoggingDriverConfig.getBooleanOption(props, "log4jdbc.trim.sql", true);
        String str = LoggingDriverConfig.getStringOption(props, "log4jdbc.drivers");
        this.drivers = str != null ? List.of(str.split(",")) : List.of();
    }

    Map<String, ParameterFormatter> getParameterFormatters() {
        return this.parameterFormatters;
    }

    ParameterFormatter getParameterFormatter(String driver) {
        if (driver == null || driver.isEmpty()) {
            return DEFAULT_PARAMETER_FORMATTER;
        }
        return this.parameterFormatters.getOrDefault(driver, DEFAULT_PARAMETER_FORMATTER);
    }

    public String getDebugStackPrefix() {
        return this.debugStackPrefix;
    }

    public boolean isTraceFromApplication() {
        return this.traceFromApplication;
    }

    public boolean isSqlTimingWarnThresholdEnabled() {
        return this.sqlTimingWarnThresholdEnabled;
    }

    public long getSqlTimingWarnThresholdNanoSec() {
        return this.sqlTimingWarnThresholdNanoSec;
    }

    public boolean isSqlTimingErrorThresholdEnabled() {
        return this.sqlTimingErrorThresholdEnabled;
    }

    public long getSqlTimingErrorThresholdNanoSec() {
        return this.sqlTimingErrorThresholdNanoSec;
    }

    public boolean isDumpSqlSelect() {
        return this.dumpSqlSelect;
    }

    public boolean isDumpSqlInsert() {
        return this.dumpSqlInsert;
    }

    public boolean isDumpSqlUpdate() {
        return this.dumpSqlUpdate;
    }

    public boolean isDumpSqlDelete() {
        return this.dumpSqlDelete;
    }

    public boolean isDumpSqlCreate() {
        return this.dumpSqlCreate;
    }

    public boolean isReportOriginalSql() {
        return this.reportOriginalSql;
    }

    public boolean isShouldUseMarkersForTimingReports() {
        return this.shouldUseMarkersForTimingReports;
    }

    public boolean isDumpSqlFilteringOn() {
        return this.dumpSqlFilteringOn;
    }

    public boolean isDumpFullDebugStackTrace() {
        return this.dumpFullDebugStackTrace;
    }

    public boolean isAutoLoadPopularDrivers() {
        return this.autoLoadPopularDrivers;
    }

    public boolean isTrimSql() {
        return this.trimSql;
    }

    public List<String> getDrivers() {
        return this.drivers;
    }

    private static Long getLongOption(Properties props, String propName) {
        String propValue = props.getProperty(propName);
        Long longPropValue = null;
        if (propValue != null) {
            try {
                longPropValue = Long.parseLong(propValue);
                log.debug("  " + propName + " = " + longPropValue);
            }
            catch (NumberFormatException ex) {
                log.debug("x " + propName + " \"" + propValue + "\" is not a valid number");
            }
        } else {
            log.debug("x " + propName + " is not defined");
        }
        return longPropValue;
    }

    private static Long getLongOption(Properties props, String propName, long defaultValue) {
        Long longPropValue;
        String propValue = props.getProperty(propName);
        if (propValue == null) {
            log.debug("x " + propName + " is not defined (using default of " + defaultValue + ")");
            return defaultValue;
        }
        try {
            longPropValue = Long.parseLong(propValue);
            log.debug("  " + propName + " = " + longPropValue);
        }
        catch (NumberFormatException n) {
            log.debug("x " + propName + " \"" + propValue + "\" is not a valid number (using default of " + defaultValue + ")");
            longPropValue = defaultValue;
        }
        return longPropValue;
    }

    private static String getStringOption(Properties props, String propName) {
        String propValue = props.getProperty(propName);
        if (propValue == null || propValue.isEmpty()) {
            log.debug("x " + propName + " is not defined");
            propValue = null;
        } else {
            log.debug("  " + propName + " = " + propValue);
        }
        return propValue;
    }

    private static boolean getBooleanOption(Properties props, String propName, boolean defaultValue) {
        String propValue = props.getProperty(propName);
        if (propValue == null) {
            log.debug("x " + propName + " is not defined (using default value " + defaultValue + ")");
            return defaultValue;
        }
        boolean val = (propValue = propValue.trim().toLowerCase()).isEmpty() ? defaultValue : "true".equals(propValue) || "yes".equals(propValue) || "on".equals(propValue);
        log.debug("  " + propName + " = " + val);
        return val;
    }
}

