/*
 * Decompiled with CFR 0.152.
 */
package org.digitalforge.log4jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.digitalforge.log4jdbc.JdbcSpy;
import org.digitalforge.log4jdbc.LoggingStatement;
import org.digitalforge.log4jdbc.SpyLogDelegator;
import org.digitalforge.log4jdbc.SpyLogFactory;

public class LoggingResultSet
implements ResultSet,
JdbcSpy {
    private final SpyLogDelegator log;
    private ResultSet delegate;
    private LoggingStatement parent;

    protected void reportException(String methodCall, SQLException exception) {
        this.log.exceptionOccured(this, methodCall, exception, null, -1L);
    }

    protected void reportAllReturns(String methodCall, String msg) {
        this.log.methodReturned(this, methodCall, msg);
    }

    public ResultSet getDelegate() {
        return this.delegate;
    }

    public LoggingResultSet(LoggingStatement parent, ResultSet delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Must provide a non null real ResultSet");
        }
        this.delegate = delegate;
        this.parent = parent;
        this.log = SpyLogFactory.getSpyLogDelegator();
        this.reportReturn("new ResultSet");
    }

    @Override
    public String getClassType() {
        return "ResultSet";
    }

    @Override
    public Integer getConnectionNumber() {
        return this.parent.getConnectionNumber();
    }

    protected boolean reportReturn(String methodCall, boolean value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected byte reportReturn(String methodCall, byte value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected int reportReturn(String methodCall, int value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected double reportReturn(String methodCall, double value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected short reportReturn(String methodCall, short value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected long reportReturn(String methodCall, long value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected float reportReturn(String methodCall, float value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected Object reportReturn(String methodCall, Object value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    protected void reportReturn(String methodCall) {
        this.reportAllReturns(methodCall, "");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        String methodCall = "updateAsciiStream(" + columnIndex + ", " + x + ", " + length + ")";
        try {
            this.delegate.updateAsciiStream(columnIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        String methodCall = "updateAsciiStream(" + columnName + ", " + x + ", " + length + ")";
        try {
            this.delegate.updateAsciiStream(columnName, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int getRow() throws SQLException {
        String methodCall = "getRow()";
        try {
            return this.reportReturn(methodCall, this.delegate.getRow());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        String methodCall = "cancelRowUpdates()";
        try {
            this.delegate.cancelRowUpdates();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        String methodCall = "getTime(" + columnIndex + ")";
        try {
            return (Time)this.reportReturn(methodCall, this.delegate.getTime(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        String methodCall = "getTime(" + columnName + ")";
        try {
            return (Time)this.reportReturn(methodCall, this.delegate.getTime(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        String methodCall = "getTime(" + columnIndex + ", " + cal + ")";
        try {
            return (Time)this.reportReturn(methodCall, this.delegate.getTime(columnIndex, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        String methodCall = "getTime(" + columnName + ", " + cal + ")";
        try {
            return (Time)this.reportReturn(methodCall, this.delegate.getTime(columnName, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        String methodCall = "absolute(" + row + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.absolute(row));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        String methodCall = "getTimestamp(" + columnIndex + ")";
        try {
            return (Timestamp)this.reportReturn(methodCall, this.delegate.getTimestamp(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        String methodCall = "getTimestamp(" + columnName + ")";
        try {
            return (Timestamp)this.reportReturn(methodCall, this.delegate.getTimestamp(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        String methodCall = "getTimestamp(" + columnIndex + ", " + cal + ")";
        try {
            return (Timestamp)this.reportReturn(methodCall, this.delegate.getTimestamp(columnIndex, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        String methodCall = "getTimestamp(" + columnName + ", " + cal + ")";
        try {
            return (Timestamp)this.reportReturn(methodCall, this.delegate.getTimestamp(columnName, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        String methodCall = "moveToInsertRow()";
        try {
            this.delegate.moveToInsertRow();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        String methodCall = "relative(" + rows + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.relative(rows));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        String methodCall = "previous()";
        try {
            return this.reportReturn(methodCall, this.delegate.previous());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        String methodCall = "moveToCurrentRow()";
        try {
            this.delegate.moveToCurrentRow();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        String methodCall = "getRef(" + i + ")";
        try {
            return (Ref)this.reportReturn(methodCall, this.delegate.getRef(i));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        String methodCall = "updateRef(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateRef(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        String methodCall = "getRef(" + colName + ")";
        try {
            return (Ref)this.reportReturn(methodCall, this.delegate.getRef(colName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        String methodCall = "updateRef(" + columnName + ", " + x + ")";
        try {
            this.delegate.updateRef(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        String methodCall = "getBlob(" + i + ")";
        try {
            return (Blob)this.reportReturn(methodCall, this.delegate.getBlob(i));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        String methodCall = "updateBlob(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateBlob(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        String methodCall = "getBlob(" + colName + ")";
        try {
            return (Blob)this.reportReturn(methodCall, this.delegate.getBlob(colName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        String methodCall = "updateBlob(" + columnName + ", " + x + ")";
        try {
            this.delegate.updateBlob(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        String methodCall = "getClob(" + i + ")";
        try {
            return (Clob)this.reportReturn(methodCall, this.delegate.getClob(i));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        String methodCall = "updateClob(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateClob(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        String methodCall = "getClob(" + colName + ")";
        try {
            return (Clob)this.reportReturn(methodCall, this.delegate.getClob(colName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        String methodCall = "updateClob(" + columnName + ", " + x + ")";
        try {
            this.delegate.updateClob(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        String methodCall = "getBoolean(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getBoolean(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        String methodCall = "getBoolean(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getBoolean(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Array getArray(int i) throws SQLException {
        String methodCall = "getArray(" + i + ")";
        try {
            return (Array)this.reportReturn(methodCall, this.delegate.getArray(i));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        String methodCall = "updateArray(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateArray(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        String methodCall = "getArray(" + colName + ")";
        try {
            return (Array)this.reportReturn(methodCall, this.delegate.getArray(colName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        String methodCall = "updateArray(" + columnName + ", " + x + ")";
        try {
            this.delegate.updateArray(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        String methodCall = "getRowId(" + columnIndex + ")";
        try {
            return (RowId)this.reportReturn(methodCall, this.delegate.getRowId(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        String methodCall = "getRowId(" + columnLabel + ")";
        try {
            return (RowId)this.reportReturn(methodCall, this.delegate.getRowId(columnLabel));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        String methodCall = "updateRowId(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateRowId(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        String methodCall = "updateRowId(" + columnLabel + ", " + x + ")";
        try {
            this.delegate.updateRowId(columnLabel, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int getHoldability() throws SQLException {
        String methodCall = "getHoldability()";
        try {
            return this.reportReturn(methodCall, this.delegate.getHoldability());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        String methodCall = "isClosed()";
        try {
            return this.reportReturn(methodCall, this.delegate.isClosed());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        String methodCall = "updateNString(" + columnIndex + ", " + nString + ")";
        try {
            this.delegate.updateNString(columnIndex, nString);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        String methodCall = "updateNString(" + columnLabel + ", " + nString + ")";
        try {
            this.delegate.updateNString(columnLabel, nString);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        String methodCall = "updateNClob(" + columnIndex + ", " + nClob + ")";
        try {
            this.delegate.updateNClob(columnIndex, nClob);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        String methodCall = "updateNClob(" + columnLabel + ", " + nClob + ")";
        try {
            this.delegate.updateNClob(columnLabel, nClob);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        String methodCall = "getNClob(" + columnIndex + ")";
        try {
            return (NClob)this.reportReturn(methodCall, this.delegate.getNClob(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        String methodCall = "getNClob(" + columnLabel + ")";
        try {
            return (NClob)this.reportReturn(methodCall, this.delegate.getNClob(columnLabel));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        String methodCall = "getSQLXML(" + columnIndex + ")";
        try {
            return (SQLXML)this.reportReturn(methodCall, this.delegate.getSQLXML(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        String methodCall = "getSQLXML(" + columnLabel + ")";
        try {
            return (SQLXML)this.reportReturn(methodCall, this.delegate.getSQLXML(columnLabel));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        String methodCall = "updateSQLXML(" + columnIndex + ", " + xmlObject + ")";
        try {
            this.delegate.updateSQLXML(columnIndex, xmlObject);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        String methodCall = "updateSQLXML(" + columnLabel + ", " + xmlObject + ")";
        try {
            this.delegate.updateSQLXML(columnLabel, xmlObject);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        String methodCall = "getNString(" + columnIndex + ")";
        try {
            return (String)this.reportReturn(methodCall, this.delegate.getNString(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        String methodCall = "getNString(" + columnLabel + ")";
        try {
            return (String)this.reportReturn(methodCall, this.delegate.getNString(columnLabel));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        String methodCall = "getNCharacterStream(" + columnIndex + ")";
        try {
            return (Reader)this.reportReturn(methodCall, this.delegate.getNCharacterStream(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        String methodCall = "getNCharacterStream(" + columnLabel + ")";
        try {
            return (Reader)this.reportReturn(methodCall, this.delegate.getNCharacterStream(columnLabel));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        String methodCall = "updateNCharacterStream(" + columnIndex + ", " + x + ", " + length + ")";
        try {
            this.delegate.updateNCharacterStream(columnIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        String methodCall = "updateNCharacterStream(" + columnLabel + ", " + reader + ", " + length + ")";
        try {
            this.delegate.updateNCharacterStream(columnLabel, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        String methodCall = "updateAsciiStream(" + columnIndex + ", " + x + ", " + length + ")";
        try {
            this.delegate.updateAsciiStream(columnIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        String methodCall = "updateBinaryStream(" + columnIndex + ", " + x + ", " + length + ")";
        try {
            this.delegate.updateBinaryStream(columnIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        String methodCall = "updateCharacterStream(" + columnIndex + ", " + x + ", " + length + ")";
        try {
            this.delegate.updateCharacterStream(columnIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        String methodCall = "updateAsciiStream(" + columnLabel + ", " + x + ", " + length + ")";
        try {
            this.delegate.updateAsciiStream(columnLabel, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        String methodCall = "updateBinaryStream(" + columnLabel + ", " + x + ", " + length + ")";
        try {
            this.delegate.updateBinaryStream(columnLabel, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        String methodCall = "updateCharacterStream(" + columnLabel + ", " + reader + ", " + length + ")";
        try {
            this.delegate.updateCharacterStream(columnLabel, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        String methodCall = "updateBlob(" + columnIndex + ", " + inputStream + ", " + length + ")";
        try {
            this.delegate.updateBlob(columnIndex, inputStream, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        String methodCall = "updateBlob(" + columnLabel + ", " + inputStream + ", " + length + ")";
        try {
            this.delegate.updateBlob(columnLabel, inputStream, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        String methodCall = "updateClob(" + columnIndex + ", " + reader + ", " + length + ")";
        try {
            this.delegate.updateClob(columnIndex, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        String methodCall = "updateClob(" + columnLabel + ", " + reader + ", " + length + ")";
        try {
            this.delegate.updateClob(columnLabel, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        String methodCall = "updateNClob(" + columnIndex + ", " + reader + ", " + length + ")";
        try {
            this.delegate.updateNClob(columnIndex, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        String methodCall = "updateNClob(" + columnLabel + ", " + reader + ", " + length + ")";
        try {
            this.delegate.updateNClob(columnLabel, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader) throws SQLException {
        String methodCall = "updateNCharacterStream(" + columnIndex + ", " + reader + ")";
        try {
            this.delegate.updateNCharacterStream(columnIndex, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        String methodCall = "updateNCharacterStream(" + columnLabel + ", " + reader + ")";
        try {
            this.delegate.updateNCharacterStream(columnLabel, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        String methodCall = "updateAsciiStream(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateAsciiStream(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        String methodCall = "updateBinaryStream(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateBinaryStream(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        String methodCall = "updateCharacterStream(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateCharacterStream(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        String methodCall = "updateAsciiStream(" + columnLabel + ", " + x + ")";
        try {
            this.delegate.updateAsciiStream(columnLabel, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        String methodCall = "updateBinaryStream(" + columnLabel + ", " + x + ")";
        try {
            this.delegate.updateBinaryStream(columnLabel, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        String methodCall = "updateCharacterStream(" + columnLabel + ", " + reader + ")";
        try {
            this.delegate.updateCharacterStream(columnLabel, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        String methodCall = "updateBlob(" + columnIndex + ", " + inputStream + ")";
        try {
            this.delegate.updateBlob(columnIndex, inputStream);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        String methodCall = "updateBlob(" + columnLabel + ", " + inputStream + ")";
        try {
            this.delegate.updateBlob(columnLabel, inputStream);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        String methodCall = "updateClob(" + columnIndex + ", " + reader + ")";
        try {
            this.delegate.updateClob(columnIndex, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        String methodCall = "updateClob(" + columnLabel + ", " + reader + ")";
        try {
            this.delegate.updateClob(columnLabel, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        String methodCall = "updateNClob(" + columnIndex + ", " + reader + ")";
        try {
            this.delegate.updateNClob(columnIndex, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        String methodCall = "updateNClob(" + columnLabel + ", " + reader + ")";
        try {
            this.delegate.updateNClob(columnLabel, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        String methodCall = "getObject(" + columnIndex + ", " + type.getName() + ")";
        try {
            return (T)this.reportReturn(methodCall, this.delegate.getObject(columnIndex, type));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        String methodCall = "getObject(" + columnLabel + ", " + type.getName() + ")";
        try {
            return (T)this.reportReturn(methodCall, this.delegate.getObject(columnLabel, type));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        String methodCall = "updateObject(" + columnIndex + ", " + x + ", " + targetSqlType.getName() + ", " + scaleOrLength + ")";
        try {
            this.delegate.updateObject(columnIndex, x, targetSqlType, scaleOrLength);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        String methodCall = "updateObject(" + columnLabel + ", " + x + ", " + targetSqlType.getName() + ", " + scaleOrLength + ")";
        try {
            this.delegate.updateObject(columnLabel, x, targetSqlType, scaleOrLength);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        String methodCall = "updateObject(" + columnIndex + ", " + x + ", " + targetSqlType.getName() + ")";
        try {
            this.delegate.updateObject(columnIndex, x, targetSqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        String methodCall = "updateObject(" + columnLabel + ", " + x + ", " + targetSqlType.getName() + ")";
        try {
            this.delegate.updateObject(columnLabel, x, targetSqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        String methodCall = "isBeforeFirst()";
        try {
            return this.reportReturn(methodCall, this.delegate.isBeforeFirst());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        String methodCall = "getShort(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getShort(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        String methodCall = "getShort(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getShort(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        String methodCall = "getInt(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getInt(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        String methodCall = "getInt(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getInt(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void close() throws SQLException {
        String methodCall = "close()";
        try {
            this.delegate.close();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        String methodCall = "getMetaData()";
        try {
            return (ResultSetMetaData)this.reportReturn(methodCall, this.delegate.getMetaData());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getType() throws SQLException {
        String methodCall = "getType()";
        try {
            return this.reportReturn(methodCall, this.delegate.getType());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        String methodCall = "getDouble(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getDouble(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        String methodCall = "getDouble(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getDouble(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        String methodCall = "deleteRow()";
        try {
            this.delegate.deleteRow();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int getConcurrency() throws SQLException {
        String methodCall = "getConcurrency()";
        try {
            return this.reportReturn(methodCall, this.delegate.getConcurrency());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        String methodCall = "rowUpdated()";
        try {
            return this.reportReturn(methodCall, this.delegate.rowUpdated());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        String methodCall = "getDate(" + columnIndex + ")";
        try {
            return (Date)this.reportReturn(methodCall, this.delegate.getDate(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        String methodCall = "getDate(" + columnName + ")";
        try {
            return (Date)this.reportReturn(methodCall, this.delegate.getDate(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        String methodCall = "getDate(" + columnIndex + ", " + cal + ")";
        try {
            return (Date)this.reportReturn(methodCall, this.delegate.getDate(columnIndex, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        String methodCall = "getDate(" + columnName + ", " + cal + ")";
        try {
            return (Date)this.reportReturn(methodCall, this.delegate.getDate(columnName, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean last() throws SQLException {
        String methodCall = "last()";
        try {
            return this.reportReturn(methodCall, this.delegate.last());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        String methodCall = "rowInserted()";
        try {
            return this.reportReturn(methodCall, this.delegate.rowInserted());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        String methodCall = "rowDeleted()";
        try {
            return this.reportReturn(methodCall, this.delegate.rowDeleted());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        String methodCall = "updateNull(" + columnIndex + ")";
        try {
            this.delegate.updateNull(columnIndex);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        String methodCall = "updateNull(" + columnName + ")";
        try {
            this.delegate.updateNull(columnName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        String methodCall = "updateShort(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateShort(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        String methodCall = "updateShort(" + columnName + ", " + x + ")";
        try {
            this.delegate.updateShort(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        String methodCall = "updateBoolean(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateBoolean(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        String methodCall = "updateBoolean(" + columnName + ", " + x + ")";
        try {
            this.delegate.updateBoolean(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        String methodCall = "updateByte(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateByte(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        String methodCall = "updateByte(" + columnName + ", " + x + ")";
        try {
            this.delegate.updateByte(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        String methodCall = "updateInt(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateInt(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        String methodCall = "updateInt(" + columnName + ", " + x + ")";
        try {
            this.delegate.updateInt(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        String methodCall = "getObject(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getObject(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        String methodCall = "getObject(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getObject(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Object getObject(String colName, Map map) throws SQLException {
        String methodCall = "getObject(" + colName + ", " + map + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getObject(colName, map));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean next() throws SQLException {
        String methodCall = "next()";
        try {
            return this.reportReturn(methodCall, this.delegate.next());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        String methodCall = "updateLong(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateLong(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        String methodCall = "updateLong(" + columnName + ", " + x + ")";
        try {
            this.delegate.updateLong(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        String methodCall = "updateFloat(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateFloat(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        String methodCall = "updateFloat(" + columnName + ", " + x + ")";
        try {
            this.delegate.updateFloat(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        String methodCall = "updateDouble(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateDouble(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        String methodCall = "updateDouble(" + columnName + ", " + x + ")";
        try {
            this.delegate.updateDouble(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public Statement getStatement() throws SQLException {
        String methodCall = "getStatement()";
        return (Statement)this.reportReturn(methodCall, this.parent);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        String methodCall = "getObject(" + columnIndex + ", " + map + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getObject(columnIndex, map));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        String methodCall = "updateString(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateString(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        String methodCall = "updateString(" + columnName + ", " + x + ")";
        try {
            this.delegate.updateString(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String methodCall = "getAsciiStream(" + columnIndex + ")";
        try {
            return (InputStream)this.reportReturn(methodCall, this.delegate.getAsciiStream(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        String methodCall = "getAsciiStream(" + columnName + ")";
        try {
            return (InputStream)this.reportReturn(methodCall, this.delegate.getAsciiStream(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        String methodCall = "updateBigDecimal(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateBigDecimal(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        String methodCall = "getURL(" + columnIndex + ")";
        try {
            return (URL)this.reportReturn(methodCall, this.delegate.getURL(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        String methodCall = "updateBigDecimal(" + columnName + ", " + x + ")";
        try {
            this.delegate.updateBigDecimal(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        String methodCall = "getURL(" + columnName + ")";
        try {
            return (URL)this.reportReturn(methodCall, this.delegate.getURL(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        String methodCall = "updateBytes(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateBytes(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        String methodCall = "updateBytes(" + columnName + ", " + x + ")";
        try {
            this.delegate.updateBytes(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        String methodCall = "getUnicodeStream(" + columnIndex + ")";
        try {
            return (InputStream)this.reportReturn(methodCall, this.delegate.getUnicodeStream(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        String methodCall = "getUnicodeStream(" + columnName + ")";
        try {
            return (InputStream)this.reportReturn(methodCall, this.delegate.getUnicodeStream(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        String methodCall = "updateDate(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateDate(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        String methodCall = "updateDate(" + columnName + ", " + x + ")";
        try {
            this.delegate.updateDate(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int getFetchSize() throws SQLException {
        String methodCall = "getFetchSize()";
        try {
            return this.reportReturn(methodCall, this.delegate.getFetchSize());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        String methodCall = "getWarnings()";
        try {
            return (SQLWarning)this.reportReturn(methodCall, this.delegate.getWarnings());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        String methodCall = "getBinaryStream(" + columnIndex + ")";
        try {
            return (InputStream)this.reportReturn(methodCall, this.delegate.getBinaryStream(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        String methodCall = "getBinaryStream(" + columnName + ")";
        try {
            return (InputStream)this.reportReturn(methodCall, this.delegate.getBinaryStream(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        String methodCall = "clearWarnings()";
        try {
            this.delegate.clearWarnings();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        String methodCall = "updateTimestamp(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateTimestamp(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        String methodCall = "updateTimestamp(" + columnName + ", " + x + ")";
        try {
            this.delegate.updateTimestamp(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public boolean first() throws SQLException {
        String methodCall = "first()";
        try {
            return this.reportReturn(methodCall, this.delegate.first());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        String methodCall = "getCursorName()";
        try {
            return (String)this.reportReturn(methodCall, this.delegate.getCursorName());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        String methodCall = "findColumn(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.findColumn(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        String methodCall = "wasNull()";
        try {
            return this.reportReturn(methodCall, this.delegate.wasNull());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        String methodCall = "updateBinaryStream(" + columnIndex + ", " + x + ", " + length + ")";
        try {
            this.delegate.updateBinaryStream(columnIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        String methodCall = "updateBinaryStream(" + columnName + ", " + x + ", " + length + ")";
        try {
            this.delegate.updateBinaryStream(columnName, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        String methodCall = "getString(" + columnIndex + ")";
        try {
            return (String)this.reportReturn(methodCall, this.delegate.getString(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public String getString(String columnName) throws SQLException {
        String methodCall = "getString(" + columnName + ")";
        try {
            return (String)this.reportReturn(methodCall, this.delegate.getString(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String methodCall = "getCharacterStream(" + columnIndex + ")";
        try {
            return (Reader)this.reportReturn(methodCall, this.delegate.getCharacterStream(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        String methodCall = "getCharacterStream(" + columnName + ")";
        try {
            return (Reader)this.reportReturn(methodCall, this.delegate.getCharacterStream(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        String methodCall = "setFetchDirection(" + direction + ")";
        try {
            this.delegate.setFetchDirection(direction);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        String methodCall = "updateCharacterStream(" + columnIndex + ", " + x + ", " + length + ")";
        try {
            this.delegate.updateCharacterStream(columnIndex, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        String methodCall = "updateCharacterStream(" + columnName + ", " + reader + ", " + length + ")";
        try {
            this.delegate.updateCharacterStream(columnName, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        String methodCall = "getByte(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getByte(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        String methodCall = "getByte(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getByte(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        String methodCall = "updateTime(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateTime(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        String methodCall = "updateTime(" + columnName + ", " + x + ")";
        try {
            this.delegate.updateTime(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        String methodCall = "getBytes(" + columnIndex + ")";
        try {
            return (byte[])this.reportReturn(methodCall, this.delegate.getBytes(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        String methodCall = "getBytes(" + columnName + ")";
        try {
            return (byte[])this.reportReturn(methodCall, this.delegate.getBytes(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        String methodCall = "isAfterLast()";
        try {
            return this.reportReturn(methodCall, this.delegate.isAfterLast());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        String methodCall = "updateObject(" + columnIndex + ", " + x + ", " + scale + ")";
        try {
            this.delegate.updateObject(columnIndex, x, scale);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        String methodCall = "updateObject(" + columnIndex + ", " + x + ")";
        try {
            this.delegate.updateObject(columnIndex, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        String methodCall = "updateObject(" + columnName + ", " + x + ", " + scale + ")";
        try {
            this.delegate.updateObject(columnName, x, scale);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        String methodCall = "updateObject(" + columnName + ", " + x + ")";
        try {
            this.delegate.updateObject(columnName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        String methodCall = "getFetchDirection()";
        try {
            return this.reportReturn(methodCall, this.delegate.getFetchDirection());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        String methodCall = "getLong(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getLong(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        String methodCall = "getLong(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getLong(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        String methodCall = "isFirst()";
        try {
            return this.reportReturn(methodCall, this.delegate.isFirst());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void insertRow() throws SQLException {
        String methodCall = "insertRow()";
        try {
            this.delegate.insertRow();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        String methodCall = "getFloat(" + columnIndex + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getFloat(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        String methodCall = "getFloat(" + columnName + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getFloat(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        String methodCall = "isLast()";
        try {
            return this.reportReturn(methodCall, this.delegate.isLast());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        String methodCall = "setFetchSize(" + rows + ")";
        try {
            this.delegate.setFetchSize(rows);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void updateRow() throws SQLException {
        String methodCall = "updateRow()";
        try {
            this.delegate.updateRow();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void beforeFirst() throws SQLException {
        String methodCall = "beforeFirst()";
        try {
            this.delegate.beforeFirst();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        String methodCall = "getBigDecimal(" + columnIndex + ", " + scale + ")";
        try {
            return (BigDecimal)this.reportReturn(methodCall, this.delegate.getBigDecimal(columnIndex, scale));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        String methodCall = "getBigDecimal(" + columnName + ", " + scale + ")";
        try {
            return (BigDecimal)this.reportReturn(methodCall, this.delegate.getBigDecimal(columnName, scale));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        String methodCall = "getBigDecimal(" + columnIndex + ")";
        try {
            return (BigDecimal)this.reportReturn(methodCall, this.delegate.getBigDecimal(columnIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        String methodCall = "getBigDecimal(" + columnName + ")";
        try {
            return (BigDecimal)this.reportReturn(methodCall, this.delegate.getBigDecimal(columnName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        String methodCall = "afterLast()";
        try {
            this.delegate.afterLast();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void refreshRow() throws SQLException {
        String methodCall = "refreshRow()";
        try {
            this.delegate.refreshRow();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String methodCall = "unwrap(" + (iface == null ? "null" : iface.getName()) + ")";
        try {
            return (T)this.reportReturn(methodCall, iface != null && (iface == ResultSet.class || iface == JdbcSpy.class) ? this : this.delegate.unwrap(iface));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String methodCall = "isWrapperFor(" + (iface == null ? "null" : iface.getName()) + ")";
        try {
            return this.reportReturn(methodCall, iface != null && (iface == ResultSet.class || iface == JdbcSpy.class) || this.delegate.isWrapperFor(iface));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }
}

