/*
 * Decompiled with CFR 0.152.
 */
package org.digitalforge.log4jdbc.util;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.digitalforge.log4jdbc.LoggingConnection;
import org.digitalforge.log4jdbc.LoggingStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionTracker {
    private static final Logger log = LoggerFactory.getLogger(ConnectionTracker.class);
    private static final int CONNECTION_DUMP_THRESHOLD = Integer.parseInt(System.getenv().getOrDefault("LOG4JDBC_CONNECTION_DUMP_THRESHOLD", "0"));
    private final Map<Integer, LoggingConnection> connections = new ConcurrentHashMap<Integer, LoggingConnection>();
    private final Set<LoggingStatement> statements = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private Instant lastDumpTime;

    public void track(int number, LoggingConnection connection) {
        this.connections.put(number, connection);
        if (this.connections.size() < CONNECTION_DUMP_THRESHOLD) {
            return;
        }
        if (this.lastDumpTime != null && !this.lastDumpTime.isBefore(Instant.now().minus(10L, ChronoUnit.MINUTES))) {
            return;
        }
        this.dumpStatements();
    }

    public void track(LoggingStatement statement) {
        this.statements.add(statement);
    }

    public void untrack(int number) {
        this.connections.remove(number);
    }

    public void untrack(LoggingStatement statement) {
        this.statements.remove(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOpenConnectionsDump() {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = this.connections;
        synchronized (this.connections) {
            int size = this.connections.size();
            if (size == 0) {
                // ** MonitorExit[var4_2] (shouldn't be in output)
                return "open connections: none";
            }
            Object[] keys = this.connections.keySet().toArray(new Integer[size]);
            // ** MonitorExit[var4_2] (shouldn't be in output)
            Arrays.sort(keys);
            sb.append("open connections: ");
            sb.append("(");
            sb.append(size);
            sb.append(") ");
            for (Object key : keys) {
                sb.append(key);
                sb.append(" ");
            }
            return sb.toString().trim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpStatements() {
        ArrayList<String> sql;
        this.lastDumpTime = Instant.now();
        Set<LoggingStatement> set = this.statements;
        synchronized (set) {
            sql = new ArrayList<String>(this.statements.size());
            for (LoggingStatement s : this.statements) {
                sql.add(s.getCurrentSql());
            }
        }
        for (String s : sql) {
            log.info("Active statement: " + s);
        }
    }
}

