/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean.copier;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.UnaryOperator;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.convert.Converter;
import org.dromara.hutool.core.func.LambdaUtil;
import org.dromara.hutool.core.func.SerFunction;
import org.dromara.hutool.core.lang.mutable.MutableEntry;

public class CopyOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Class<?> editable;
    protected boolean ignoreNullValue;
    protected boolean ignoreError;
    protected boolean ignoreCase;
    private BiPredicate<Field, Object> propertiesFilter;
    protected UnaryOperator<MutableEntry<String, Object>> fieldEditor;
    protected boolean transientSupport = true;
    protected boolean override = true;
    protected Converter converter = (type, value) -> Convert.convertWithCheck(type, value, null, this.ignoreError);

    public static CopyOptions of() {
        return new CopyOptions();
    }

    public static CopyOptions of(Class<?> editable, boolean ignoreNullValue, String ... ignoreProperties) {
        return new CopyOptions(editable, ignoreNullValue, ignoreProperties);
    }

    public CopyOptions() {
    }

    public CopyOptions(Class<?> editable, boolean ignoreNullValue, String ... ignoreProperties) {
        this.propertiesFilter = (f, v) -> true;
        this.editable = editable;
        this.ignoreNullValue = ignoreNullValue;
        this.setIgnoreProperties(ignoreProperties);
    }

    public CopyOptions setEditable(Class<?> editable) {
        this.editable = editable;
        return this;
    }

    public CopyOptions setIgnoreNullValue(boolean ignoreNullVall) {
        this.ignoreNullValue = ignoreNullVall;
        return this;
    }

    public CopyOptions ignoreNullValue() {
        return this.setIgnoreNullValue(true);
    }

    public CopyOptions setPropertiesFilter(BiPredicate<Field, Object> propertiesFilter) {
        this.propertiesFilter = propertiesFilter;
        return this;
    }

    public CopyOptions setIgnoreProperties(String ... ignoreProperties) {
        return this.setPropertiesFilter((field, o) -> !ArrayUtil.contains(ignoreProperties, field.getName()));
    }

    public <P, R> CopyOptions setIgnoreProperties(SerFunction<P, R> ... funcs) {
        Set<String> ignoreProperties = ArrayUtil.mapToSet(funcs, LambdaUtil::getFieldName);
        return this.setPropertiesFilter((field, o) -> !ignoreProperties.contains(field.getName()));
    }

    public CopyOptions setIgnoreError(boolean ignoreError) {
        this.ignoreError = ignoreError;
        return this;
    }

    public CopyOptions ignoreError() {
        return this.setIgnoreError(true);
    }

    public CopyOptions setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    public CopyOptions ignoreCase() {
        return this.setIgnoreCase(true);
    }

    public CopyOptions setFieldMapping(Map<String, String> fieldMapping) {
        return this.setFieldEditor(entry -> {
            String key = (String)entry.getKey();
            entry.setKey(fieldMapping.getOrDefault(key, key));
            return entry;
        });
    }

    public CopyOptions setFieldEditor(UnaryOperator<MutableEntry<String, Object>> editor) {
        this.fieldEditor = editor;
        return this;
    }

    protected MutableEntry<String, Object> editField(String fieldName, Object fieldValue) {
        MutableEntry entry = new MutableEntry(fieldName, fieldValue);
        return null != this.fieldEditor ? (MutableEntry)this.fieldEditor.apply(entry) : entry;
    }

    public CopyOptions setTransientSupport(boolean transientSupport) {
        this.transientSupport = transientSupport;
        return this;
    }

    public CopyOptions setOverride(boolean override) {
        this.override = override;
        return this;
    }

    public CopyOptions setConverter(Converter converter) {
        this.converter = converter;
        return this;
    }

    protected Object convertField(Type targetType, Object fieldValue) {
        return null != this.converter ? this.converter.convert(targetType, fieldValue) : fieldValue;
    }

    protected boolean testPropertyFilter(Field field, Object value) {
        return null == this.propertiesFilter || this.propertiesFilter.test(field, value);
    }
}

