/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.cache.impl;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.dromara.hutool.core.cache.impl.CacheObj;
import org.dromara.hutool.core.cache.impl.StampedCache;

public class FIFOCache<K, V>
extends StampedCache<K, V> {
    private static final long serialVersionUID = 1L;

    public FIFOCache(int capacity) {
        this(capacity, 0L);
    }

    public FIFOCache(int capacity, long timeout) {
        this.capacity = capacity;
        this.timeout = timeout;
        this.cacheMap = new LinkedHashMap(capacity + 1, 1.0f, false);
    }

    @Override
    protected int pruneCache() {
        int count = 0;
        CacheObj first = null;
        Iterator values = this.cacheObjIter();
        if (this.isPruneExpiredActive()) {
            while (values.hasNext()) {
                CacheObj co = values.next();
                if (co.isExpired()) {
                    values.remove();
                    this.onRemove(co.key, co.obj);
                    ++count;
                    continue;
                }
                if (first != null) continue;
                first = co;
            }
        } else {
            CacheObj cacheObj = first = values.hasNext() ? values.next() : null;
        }
        if (this.isFull() && null != first) {
            this.removeWithoutLock(first.key, false);
            this.onRemove(first.key, first.obj);
            ++count;
        }
        return count;
    }
}

