/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.collection.partition;

import java.util.AbstractList;
import java.util.List;
import org.dromara.hutool.core.lang.Assert;

public class Partition<T>
extends AbstractList<List<T>> {
    protected final List<T> list;
    protected final int size;

    public Partition(List<T> list, int size) {
        this.list = Assert.notNull(list);
        this.size = Math.min(size, list.size());
    }

    @Override
    public List<T> get(int index) {
        int start = index * this.size;
        int end = Math.min(start + this.size, this.list.size());
        return this.list.subList(start, end);
    }

    @Override
    public int size() {
        int size = this.size;
        if (0 == size) {
            return 0;
        }
        int total = this.list.size();
        return (total + size - 1) / size;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }
}

