/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.comparator;

import java.util.Comparator;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.lang.Assert;

public class IndexedComparator<T>
implements Comparator<T> {
    private final boolean atEndIfMiss;
    private final T[] array;

    public IndexedComparator(T ... objs) {
        this(false, objs);
    }

    public IndexedComparator(boolean atEndIfMiss, T ... objs) {
        Assert.notNull(objs, "'objs' array must not be null", new Object[0]);
        this.atEndIfMiss = atEndIfMiss;
        this.array = objs;
    }

    @Override
    public int compare(T o1, T o2) {
        int index2;
        int index1 = this.getOrder(o1);
        if (index1 == (index2 = this.getOrder(o2)) && (index1 < 0 || index1 == this.array.length)) {
            return 1;
        }
        return Integer.compare(index1, index2);
    }

    private int getOrder(T object) {
        int order = ArrayUtil.indexOf(this.array, object);
        if (order < 0) {
            order = this.atEndIfMiss ? this.array.length : -1;
        }
        return order;
    }
}

