/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.datatype.XMLGregorianCalendar;
import org.dromara.hutool.core.convert.CompositeConverter;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.convert.Converter;
import org.dromara.hutool.core.convert.impl.AtomicBooleanConverter;
import org.dromara.hutool.core.convert.impl.AtomicIntegerArrayConverter;
import org.dromara.hutool.core.convert.impl.AtomicLongArrayConverter;
import org.dromara.hutool.core.convert.impl.AtomicReferenceConverter;
import org.dromara.hutool.core.convert.impl.BooleanConverter;
import org.dromara.hutool.core.convert.impl.CalendarConverter;
import org.dromara.hutool.core.convert.impl.CharacterConverter;
import org.dromara.hutool.core.convert.impl.CharsetConverter;
import org.dromara.hutool.core.convert.impl.ClassConverter;
import org.dromara.hutool.core.convert.impl.CurrencyConverter;
import org.dromara.hutool.core.convert.impl.DateConverter;
import org.dromara.hutool.core.convert.impl.DurationConverter;
import org.dromara.hutool.core.convert.impl.LocaleConverter;
import org.dromara.hutool.core.convert.impl.OptConverter;
import org.dromara.hutool.core.convert.impl.OptionalConverter;
import org.dromara.hutool.core.convert.impl.PathConverter;
import org.dromara.hutool.core.convert.impl.PeriodConverter;
import org.dromara.hutool.core.convert.impl.ReferenceConverter;
import org.dromara.hutool.core.convert.impl.StackTraceElementConverter;
import org.dromara.hutool.core.convert.impl.StringConverter;
import org.dromara.hutool.core.convert.impl.TemporalAccessorConverter;
import org.dromara.hutool.core.convert.impl.TimeZoneConverter;
import org.dromara.hutool.core.convert.impl.URIConverter;
import org.dromara.hutool.core.convert.impl.URLConverter;
import org.dromara.hutool.core.convert.impl.UUIDConverter;
import org.dromara.hutool.core.convert.impl.XMLGregorianCalendarConverter;
import org.dromara.hutool.core.convert.impl.ZoneIdConverter;
import org.dromara.hutool.core.date.DateTime;
import org.dromara.hutool.core.lang.Opt;
import org.dromara.hutool.core.map.SafeConcurrentHashMap;

public class RegisterConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Type, Converter> defaultConverterMap;
    private volatile Map<Type, Converter> customConverterMap;

    public static CompositeConverter getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public RegisterConverter() {
        this.registerDefault();
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        Converter converter = this.getConverter(targetType, true);
        if (null != converter) {
            return converter.convert(targetType, value);
        }
        throw new ConvertException("Can not convert from {}: [{}] to [{}]", value.getClass().getName(), value, targetType.getTypeName());
    }

    public Converter getConverter(Type type, boolean isCustomFirst) {
        Converter converter;
        if (isCustomFirst) {
            converter = this.getCustomConverter(type);
            if (null == converter) {
                converter = this.getDefaultConverter(type);
            }
        } else {
            converter = this.getDefaultConverter(type);
            if (null == converter) {
                converter = this.getCustomConverter(type);
            }
        }
        return converter;
    }

    public Converter getDefaultConverter(Type type) {
        return null == this.defaultConverterMap ? null : this.defaultConverterMap.get(type);
    }

    public Converter getCustomConverter(Type type) {
        return null == this.customConverterMap ? null : this.customConverterMap.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterConverter putCustom(Type type, Converter converter) {
        if (null == this.customConverterMap) {
            RegisterConverter registerConverter = this;
            synchronized (registerConverter) {
                if (null == this.customConverterMap) {
                    this.customConverterMap = new SafeConcurrentHashMap<Type, Converter>();
                }
            }
        }
        this.customConverterMap.put(type, converter);
        return this;
    }

    private void registerDefault() {
        this.defaultConverterMap = new SafeConcurrentHashMap<Type, Converter>(64);
        this.defaultConverterMap.put((Type)((Object)Character.class), new CharacterConverter());
        this.defaultConverterMap.put((Type)((Object)Boolean.class), new BooleanConverter());
        this.defaultConverterMap.put((Type)((Object)AtomicBoolean.class), new AtomicBooleanConverter());
        this.defaultConverterMap.put((Type)((Object)CharSequence.class), new StringConverter());
        this.defaultConverterMap.put((Type)((Object)String.class), new StringConverter());
        this.defaultConverterMap.put((Type)((Object)URI.class), new URIConverter());
        this.defaultConverterMap.put((Type)((Object)URL.class), new URLConverter());
        this.defaultConverterMap.put((Type)((Object)Calendar.class), new CalendarConverter());
        this.defaultConverterMap.put((Type)((Object)XMLGregorianCalendar.class), new XMLGregorianCalendarConverter());
        this.defaultConverterMap.put((Type)((Object)java.util.Date.class), DateConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)DateTime.class), DateConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)Date.class), DateConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)Time.class), DateConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)Timestamp.class), DateConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)TemporalAccessor.class), TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)Instant.class), TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)LocalDateTime.class), TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)LocalDate.class), TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)LocalTime.class), TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)ZonedDateTime.class), TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)OffsetDateTime.class), TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)OffsetTime.class), TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)DayOfWeek.class), TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)Month.class), TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)MonthDay.class), TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)Period.class), new PeriodConverter());
        this.defaultConverterMap.put((Type)((Object)Duration.class), new DurationConverter());
        this.defaultConverterMap.put((Type)((Object)WeakReference.class), ReferenceConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)SoftReference.class), ReferenceConverter.INSTANCE);
        this.defaultConverterMap.put((Type)((Object)AtomicReference.class), new AtomicReferenceConverter());
        this.defaultConverterMap.put((Type)((Object)AtomicIntegerArray.class), new AtomicIntegerArrayConverter());
        this.defaultConverterMap.put((Type)((Object)AtomicLongArray.class), new AtomicLongArrayConverter());
        this.defaultConverterMap.put((Type)((Object)Class.class), new ClassConverter());
        this.defaultConverterMap.put((Type)((Object)TimeZone.class), new TimeZoneConverter());
        this.defaultConverterMap.put((Type)((Object)ZoneId.class), new ZoneIdConverter());
        this.defaultConverterMap.put((Type)((Object)Locale.class), new LocaleConverter());
        this.defaultConverterMap.put((Type)((Object)Charset.class), new CharsetConverter());
        this.defaultConverterMap.put((Type)((Object)Path.class), new PathConverter());
        this.defaultConverterMap.put((Type)((Object)Currency.class), new CurrencyConverter());
        this.defaultConverterMap.put((Type)((Object)UUID.class), new UUIDConverter());
        this.defaultConverterMap.put((Type)((Object)StackTraceElement.class), new StackTraceElementConverter());
        this.defaultConverterMap.put((Type)((Object)Optional.class), new OptionalConverter());
        this.defaultConverterMap.put((Type)((Object)Opt.class), new OptConverter());
    }

    private static class SingletonHolder {
        private static final CompositeConverter INSTANCE = new CompositeConverter();

        private SingletonHolder() {
        }
    }
}

