/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.file;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.file.PathUtil;
import org.dromara.hutool.core.io.file.visitor.DelVisitor;
import org.dromara.hutool.core.lang.Assert;

public class PathDeleter {
    private final Path path;

    public static PathDeleter of(Path src) {
        return new PathDeleter(src);
    }

    public PathDeleter(Path path) {
        this.path = Assert.notNull(path, "Path must be not null !", new Object[0]);
    }

    public void del() throws IORuntimeException {
        Path path = this.path;
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        if (PathUtil.isDirectory(path)) {
            PathDeleter._del(path);
        } else {
            PathDeleter.delFile(path);
        }
    }

    public void clean() {
        try (Stream<Path> list = Files.list(this.path);){
            list.forEach(PathUtil::del);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void _del(Path path) {
        try {
            Files.walkFileTree(path, DelVisitor.INSTANCE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void delFile(Path path) throws IORuntimeException {
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            if (e instanceof AccessDeniedException && path.toFile().delete()) {
                return;
            }
            throw new IORuntimeException(e);
        }
    }
}

