/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.lang;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.func.SerSupplier;
import org.dromara.hutool.core.text.StrUtil;

public class Opt<T> {
    private static final Opt<?> EMPTY = new Opt<Object>(null);
    private final T value;
    private Throwable throwable;

    public static <T> Opt<T> empty() {
        Opt<?> t = EMPTY;
        return t;
    }

    public static <T> Opt<T> of(T value) {
        return new Opt<T>(Objects.requireNonNull(value));
    }

    public static <T> Opt<T> ofNullable(T value) {
        return value == null ? Opt.empty() : new Opt<T>(value);
    }

    public static <T extends CharSequence> Opt<T> ofBlankAble(T value) {
        return StrUtil.isBlank(value) ? Opt.empty() : new Opt<T>(value);
    }

    public static <T, R extends Collection<T>> Opt<R> ofEmptyAble(R value) {
        return CollUtil.isEmpty(value) || CollUtil.getFirstNoneNull(value) == null ? Opt.empty() : new Opt<R>(value);
    }

    public static <T> Opt<T> ofTry(SerSupplier<T> supplier) {
        try {
            return Opt.ofNullable(supplier.getting());
        }
        catch (Throwable e) {
            Opt<Object> empty = new Opt<Object>(null);
            empty.throwable = e;
            return empty;
        }
    }

    public static <T> Opt<T> of(Optional<T> optional) {
        return Opt.ofNullable(optional.orElse(null));
    }

    private Opt(T value) {
        this.value = value;
    }

    public T get() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean isFail() {
        return null != this.throwable;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public Opt<T> ifPresent(Consumer<? super T> action) {
        if (this.isPresent()) {
            action.accept(this.value);
        }
        return this;
    }

    public Opt<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (this.isEmpty()) {
            return this;
        }
        return predicate.test(this.value) ? this : Opt.empty();
    }

    public <U> Opt<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Opt.empty();
        }
        return Opt.ofNullable(mapper.apply(this.value));
    }

    public <U> Opt<U> flatMap(Function<? super T, ? extends Opt<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Opt.empty();
        }
        Opt<? extends U> r = mapper.apply(this.value);
        return Objects.requireNonNull(r);
    }

    public <U> Opt<U> flattedMap(Function<? super T, ? extends Optional<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Opt.empty();
        }
        return Opt.ofNullable(mapper.apply(this.value).orElse(null));
    }

    public Opt<T> peek(Consumer<T> action) throws NullPointerException {
        return this.ifPresent(action);
    }

    @SafeVarargs
    public final Opt<T> peeks(Consumer<T> ... actions) throws NullPointerException {
        return this.peek(Stream.of(actions).reduce(Consumer::andThen).orElseGet(() -> o -> {}));
    }

    public Opt<T> or(Supplier<? extends Opt<? extends T>> supplier) {
        Objects.requireNonNull(supplier);
        if (this.isPresent()) {
            return this;
        }
        Opt<? extends T> r = supplier.get();
        return Objects.requireNonNull(r);
    }

    public Stream<T> stream() {
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return Stream.of(this.value);
    }

    public T orElse(T other) {
        return this.isPresent() ? this.value : other;
    }

    public T exceptionOrElse(T other) {
        return this.isFail() ? other : this.value;
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        return this.isPresent() ? this.value : supplier.get();
    }

    public T orElseRun(Runnable action) {
        if (this.isPresent()) {
            return this.value;
        }
        action.run();
        return null;
    }

    public T orElseThrow() {
        return this.orElseThrow(() -> new NoSuchElementException("No value present"));
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public Optional<T> toOptional() {
        return Optional.ofNullable(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Opt)) {
            return false;
        }
        Opt other = (Opt)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return StrUtil.toStringOrNull(this.value);
    }
}

