/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.net;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.net.Ipv4Pool;
import org.dromara.hutool.core.net.MacAddressUtil;
import org.dromara.hutool.core.net.MaskBit;
import org.dromara.hutool.core.net.NetUtil;
import org.dromara.hutool.core.regex.PatternPool;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;

public class Ipv4Util
implements Ipv4Pool {
    private static volatile String localhostName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getLocalHostName() {
        if (null != localhostName) return localhostName;
        Class<Ipv4Util> clazz = Ipv4Util.class;
        synchronized (Ipv4Util.class) {
            if (null != localhostName) return localhostName;
            localhostName = NetUtil.getAddressName(Ipv4Util.getLocalhostDirectly());
            // ** MonitorExit[var0] (shouldn't be in output)
            return localhostName;
        }
    }

    public static String getLocalMacAddress() {
        return MacAddressUtil.getMacAddress(Ipv4Util.getLocalhost());
    }

    public static byte[] getLocalHardwareAddress() {
        return MacAddressUtil.getHardwareAddress(Ipv4Util.getLocalhost());
    }

    public static InetAddress getLocalhost() {
        return Singleton.get(Ipv4Util.class.getName(), Ipv4Util::getLocalhostDirectly);
    }

    public static InetAddress getLocalhostDirectly() {
        LinkedHashSet<InetAddress> localAddressList = NetUtil.localAddressList(address -> address instanceof Inet4Address && !address.isLoopbackAddress() && !address.isSiteLocalAddress() && !address.isLinkLocalAddress());
        if (CollUtil.isNotEmpty(localAddressList)) {
            return CollUtil.getFirst(localAddressList);
        }
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            if (localHost instanceof Inet4Address) {
                return localHost;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return null;
    }

    public static InetSocketAddress buildInetSocketAddress(String host, int defaultPort) {
        int port;
        String targetHost;
        int index;
        if (StrUtil.isBlank(host)) {
            host = "127.0.0.1";
        }
        if ((index = host.indexOf(":")) != -1) {
            targetHost = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        } else {
            targetHost = host;
            port = defaultPort;
        }
        return new InetSocketAddress(targetHost, port);
    }

    public static String formatIpBlock(String ip, String mask) {
        return ip + "/" + Ipv4Util.getMaskBitByMask(mask);
    }

    public static List<String> list(String ipRange, boolean isAll) {
        if (ipRange.contains("-")) {
            String[] range = SplitUtil.splitToArray(ipRange, "-");
            return Ipv4Util.list(range[0], range[1]);
        }
        if (ipRange.contains("/")) {
            String[] param = SplitUtil.splitToArray(ipRange, "/");
            return Ipv4Util.list(param[0], Integer.parseInt(param[1]), isAll);
        }
        return ListUtil.of(ipRange);
    }

    public static List<String> list(String ip, int maskBit, boolean isAll) {
        Ipv4Util.assertMaskBitValid(maskBit);
        if (Ipv4Util.countByMaskBit(maskBit, isAll) == 0) {
            return ListUtil.zero();
        }
        long startIp = Ipv4Util.getBeginIpLong(ip, maskBit);
        long endIp = Ipv4Util.getEndIpLong(ip, maskBit);
        if (isAll) {
            return Ipv4Util.list(startIp, endIp);
        }
        if (startIp + 1L > endIp - 1L) {
            return ListUtil.zero();
        }
        return Ipv4Util.list(startIp + 1L, endIp - 1L);
    }

    public static List<String> list(String ipFrom, String ipTo) {
        return Ipv4Util.list(Ipv4Util.ipv4ToLong(ipFrom), Ipv4Util.ipv4ToLong(ipTo));
    }

    public static List<String> list(long ipFrom, long ipTo) {
        int count = Ipv4Util.countByIpRange(ipFrom, ipTo);
        ArrayList<String> ips = new ArrayList<String>(count);
        StringBuilder sb = StrUtil.builder(15);
        long end = ipTo + 1L;
        for (long ip = ipFrom; ip < end; ++ip) {
            sb.setLength(0);
            ips.add(sb.append((int)(ip >> 24) & 0xFF).append('.').append((int)(ip >> 16) & 0xFF).append('.').append((int)(ip >> 8) & 0xFF).append('.').append((int)ip & 0xFF).toString());
        }
        return ips;
    }

    public static String longToIpv4(long ip) {
        return StrUtil.builder(15).append((int)(ip >> 24) & 0xFF).append('.').append((int)(ip >> 16) & 0xFF).append('.').append((int)(ip >> 8) & 0xFF).append('.').append((int)ip & 0xFF).toString();
    }

    public static long ipv4ToLong(String strIp) {
        Matcher matcher = PatternPool.IPV4.matcher(strIp);
        Assert.isTrue(matcher.matches(), "Invalid IPv4 address: {}", strIp);
        return Ipv4Util.matchAddress(matcher);
    }

    public static String getBeginIpStr(String ip, int maskBit) {
        return Ipv4Util.longToIpv4(Ipv4Util.getBeginIpLong(ip, maskBit));
    }

    public static long getBeginIpLong(String ip, int maskBit) {
        Ipv4Util.assertMaskBitValid(maskBit);
        return Ipv4Util.ipv4ToLong(ip) & MaskBit.getMaskIpLong(maskBit);
    }

    public static String getEndIpStr(String ip, int maskBit) {
        return Ipv4Util.longToIpv4(Ipv4Util.getEndIpLong(ip, maskBit));
    }

    public static long getEndIpLong(String ip, int maskBit) {
        return Ipv4Util.getBeginIpLong(ip, maskBit) + (0xFFFFFFFFL & (MaskBit.getMaskIpLong(maskBit) ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public static int getMaskBitByMask(String mask) {
        Integer maskBit = MaskBit.getMaskBit(mask);
        Assert.notNull(maskBit, "Invalid netmask\uff1a{}", mask);
        return maskBit;
    }

    public static int countByMaskBit(int maskBit, boolean isAll) {
        Assert.isTrue(maskBit > 1 && maskBit <= 32, "Not support mask bit: {}", maskBit);
        if (maskBit == 32 && !isAll) {
            return 0;
        }
        int count = 1 << 32 - maskBit;
        return isAll ? count : count - 2;
    }

    public static String getMaskByMaskBit(int maskBit) {
        Ipv4Util.assertMaskBitValid(maskBit);
        return MaskBit.get(maskBit);
    }

    public static String getMaskByIpRange(String fromIp, String toIp) {
        long toIpLong = Ipv4Util.ipv4ToLong(toIp);
        long fromIpLong = Ipv4Util.ipv4ToLong(fromIp);
        Assert.isTrue(fromIpLong <= toIpLong, "Start IP must be less than or equal to end IP!", new Object[0]);
        return StrUtil.builder(15).append(255 - Ipv4Util.getPartOfIp(toIpLong, 1) + Ipv4Util.getPartOfIp(fromIpLong, 1)).append('.').append(255 - Ipv4Util.getPartOfIp(toIpLong, 2) + Ipv4Util.getPartOfIp(fromIpLong, 2)).append('.').append(255 - Ipv4Util.getPartOfIp(toIpLong, 3) + Ipv4Util.getPartOfIp(fromIpLong, 3)).append('.').append(255 - Ipv4Util.getPartOfIp(toIpLong, 4) + Ipv4Util.getPartOfIp(fromIpLong, 4)).toString();
    }

    public static int countByIpRange(String fromIp, String toIp) {
        return Ipv4Util.countByIpRange(Ipv4Util.ipv4ToLong(fromIp), Ipv4Util.ipv4ToLong(toIp));
    }

    public static int countByIpRange(long fromIp, long toIp) {
        Assert.isTrue(fromIp <= toIp, "Start IP must be less than or equal to end IP!", new Object[0]);
        int count = 1;
        return count += Ipv4Util.getPartOfIp(toIp, 4) - Ipv4Util.getPartOfIp(fromIp, 4) + (Ipv4Util.getPartOfIp(toIp, 3) - Ipv4Util.getPartOfIp(fromIp, 3) << 8) + (Ipv4Util.getPartOfIp(toIp, 2) - Ipv4Util.getPartOfIp(fromIp, 2) << 16) + (Ipv4Util.getPartOfIp(toIp, 1) - Ipv4Util.getPartOfIp(fromIp, 1) << 24);
    }

    public static boolean isMaskValid(String mask) {
        return MaskBit.getMaskBit(mask) != null;
    }

    public static boolean isMaskBitValid(int maskBit) {
        return maskBit >= 1 && maskBit <= 32;
    }

    public static boolean isInnerIP(String ipAddress) {
        return Ipv4Util.isInnerIP(Ipv4Util.ipv4ToLong(ipAddress));
    }

    public static boolean isInnerIP(long ipNum) {
        return Ipv4Util.isBetween(ipNum, IPV4_A_PRIVATE_NUM_MIN, IPV4_A_PRIVATE_NUM_MAX) || Ipv4Util.isBetween(ipNum, IPV4_B_PRIVATE_NUM_MIN, IPV4_B_PRIVATE_NUM_MAX) || Ipv4Util.isBetween(ipNum, IPV4_C_PRIVATE_NUM_MIN, IPV4_C_PRIVATE_NUM_MAX) || LOCAL_IP_NUM == ipNum;
    }

    public static boolean isPublicIP(String ipAddress) {
        return Ipv4Util.isPublicIP(Ipv4Util.ipv4ToLong(ipAddress));
    }

    public static boolean isPublicIP(long ipNum) {
        return Ipv4Util.isBetween(ipNum, IPV4_A_PUBLIC_1_NUM_MIN, IPV4_A_PUBLIC_1_NUM_MAX) || Ipv4Util.isBetween(ipNum, IPV4_A_PUBLIC_2_NUM_MIN, IPV4_A_PUBLIC_2_NUM_MAX) || Ipv4Util.isBetween(ipNum, IPV4_B_PUBLIC_1_NUM_MIN, IPV4_B_PUBLIC_1_NUM_MAX) || Ipv4Util.isBetween(ipNum, IPV4_B_PUBLIC_2_NUM_MIN, IPV4_B_PUBLIC_2_NUM_MAX) || Ipv4Util.isBetween(ipNum, IPV4_C_PUBLIC_1_NUM_MIN, IPV4_C_PUBLIC_1_NUM_MAX) || Ipv4Util.isBetween(ipNum, IPV4_C_PUBLIC_2_NUM_MIN, IPV4_C_PUBLIC_2_NUM_MAX);
    }

    public static int getPartOfIp(long ip, int position) {
        switch (position) {
            case 1: {
                return (int)(ip >> 24) & 0xFF;
            }
            case 2: {
                return (int)(ip >> 16) & 0xFF;
            }
            case 3: {
                return (int)(ip >> 8) & 0xFF;
            }
            case 4: {
                return (int)ip & 0xFF;
            }
        }
        throw new IllegalArgumentException("Illegal position of ip Long: " + position);
    }

    private static long matchAddress(Matcher matcher) {
        int addr = 0;
        addr |= Integer.parseInt(matcher.group(1));
        addr <<= 8;
        addr |= Integer.parseInt(matcher.group(2));
        addr <<= 8;
        addr |= Integer.parseInt(matcher.group(3));
        addr <<= 8;
        if ((addr |= Integer.parseInt(matcher.group(4))) < 0) {
            return 0xFFFFFFFFL & (long)addr;
        }
        return addr;
    }

    private static boolean isBetween(long userIp, long begin, long end) {
        return userIp >= begin && userIp <= end;
    }

    private static void assertMaskBitValid(int maskBit) {
        Assert.isTrue(Ipv4Util.isMaskBitValid(maskBit), "Invalid maskBit\uff1a{}", maskBit);
    }
}

