/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.net.ssl;

import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.lang.builder.Builder;
import org.dromara.hutool.core.net.ssl.SSLProtocols;
import org.dromara.hutool.core.net.ssl.TrustAnyTrustManager;
import org.dromara.hutool.core.text.StrUtil;

public class SSLContextBuilder
implements SSLProtocols,
Builder<SSLContext> {
    private static final long serialVersionUID = 1L;
    private String protocol = "TLS";
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers = new TrustManager[]{TrustAnyTrustManager.INSTANCE};
    private SecureRandom secureRandom = new SecureRandom();

    public static SSLContextBuilder of() {
        return new SSLContextBuilder();
    }

    public SSLContextBuilder setProtocol(String protocol) {
        if (StrUtil.isNotBlank(protocol)) {
            this.protocol = protocol;
        }
        return this;
    }

    public SSLContextBuilder setTrustManagers(TrustManager ... trustManagers) {
        if (ArrayUtil.isNotEmpty(trustManagers)) {
            this.trustManagers = trustManagers;
        }
        return this;
    }

    public SSLContextBuilder setKeyManagers(KeyManager ... keyManagers) {
        if (ArrayUtil.isNotEmpty(keyManagers)) {
            this.keyManagers = keyManagers;
        }
        return this;
    }

    public SSLContextBuilder setSecureRandom(SecureRandom secureRandom) {
        if (null != secureRandom) {
            this.secureRandom = secureRandom;
        }
        return this;
    }

    @Override
    public SSLContext build() {
        return this.buildQuietly();
    }

    public SSLContext buildChecked() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance(this.protocol);
        sslContext.init(this.keyManagers, this.trustManagers, this.secureRandom);
        return sslContext;
    }

    public SSLContext buildQuietly() throws IORuntimeException {
        try {
            return this.buildChecked();
        }
        catch (GeneralSecurityException e) {
            throw new IORuntimeException(e);
        }
    }
}

