/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.net.url;

import java.io.Serializable;
import java.nio.charset.Charset;
import org.dromara.hutool.core.io.stream.FastByteArrayOutputStream;
import org.dromara.hutool.core.text.CharUtil;
import org.dromara.hutool.core.util.CharsetUtil;

public class URLDecoder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Charset DEFAULT_CHARSET = CharsetUtil.UTF_8;
    private static final byte ESCAPE_CHAR = 37;

    public static String decodeForPath(String str, Charset charset) {
        return URLDecoder.decode(str, charset, false);
    }

    public static String decode(String str) {
        return URLDecoder.decode(str, DEFAULT_CHARSET);
    }

    public static String decode(String str, Charset charset) {
        return URLDecoder.decode(str, charset, true);
    }

    public static String decode(String str, boolean isPlusToSpace) {
        return URLDecoder.decode(str, DEFAULT_CHARSET, isPlusToSpace);
    }

    public static String decode(String str, Charset charset, boolean isPlusToSpace) {
        if (null == charset) {
            return str;
        }
        if (null == str) {
            return null;
        }
        int length = str.length();
        if (0 == length) {
            return "";
        }
        StringBuilder result = new StringBuilder(length / 3);
        int begin = 0;
        for (int i = 0; i < length; ++i) {
            int c = str.charAt(i);
            if (37 == c || CharUtil.isHexChar((char)c)) continue;
            if (i > begin) {
                result.append(URLDecoder.decodeSub(str, begin, i, charset, isPlusToSpace));
            }
            if (43 == c && isPlusToSpace) {
                c = 32;
            }
            result.append((char)c);
            begin = i + 1;
        }
        if (begin < length) {
            result.append(URLDecoder.decodeSub(str, begin, length, charset, isPlusToSpace));
        }
        return result.toString();
    }

    public static byte[] decode(byte[] bytes) {
        return URLDecoder.decode(bytes, true);
    }

    public static byte[] decode(byte[] bytes, boolean isPlusToSpace) {
        if (bytes == null) {
            return null;
        }
        FastByteArrayOutputStream buffer = new FastByteArrayOutputStream(bytes.length / 3);
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i];
            if (b == 43) {
                buffer.write(isPlusToSpace ? 32 : b);
                continue;
            }
            if (b == 37) {
                int l;
                int u;
                if (i + 1 < bytes.length && (u = CharUtil.digit16(bytes[i + 1])) >= 0 && i + 2 < bytes.length && (l = CharUtil.digit16(bytes[i + 2])) >= 0) {
                    buffer.write((char)((u << 4) + l));
                    i += 2;
                    continue;
                }
                buffer.write(b);
                continue;
            }
            buffer.write(b);
        }
        return buffer.toByteArray();
    }

    private static String decodeSub(String str, int begin, int end, Charset charset, boolean isPlusToSpace) {
        return new String(URLDecoder.decode(str.substring(begin, end).getBytes(CharsetUtil.ISO_8859_1), isPlusToSpace), charset);
    }
}

