/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.reflect.ReflectUtil;

public class ModifierUtil {
    public static boolean hasModifier(Class<?> clazz, ModifierType ... modifierTypes) {
        if (null == clazz || ArrayUtil.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (clazz.getModifiers() & ModifierUtil.modifiersToInt(modifierTypes));
    }

    public static boolean hasModifier(Member member, ModifierType ... modifierTypes) {
        if (null == member || ArrayUtil.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (member.getModifiers() & ModifierUtil.modifiersToInt(modifierTypes));
    }

    public static boolean isDefault(Method method) {
        return method.isDefault();
    }

    public static boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    public static boolean isPublic(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    public static boolean isPrivate(Class<?> clazz) {
        return Modifier.isPrivate(clazz.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isStatic(Class<?> clazz) {
        return Modifier.isStatic(clazz.getModifiers());
    }

    public static boolean isSynthetic(Member member) {
        return member.isSynthetic();
    }

    public static boolean isSynthetic(Class<?> clazz) {
        return clazz.isSynthetic();
    }

    public static boolean isAbstract(Member member) {
        return Modifier.isAbstract(member.getModifiers());
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isInterface(Class<?> clazz) {
        return null != clazz && clazz.isInterface();
    }

    public static void removeFinalModify(Field field) {
        Field modifiersField;
        if (!ModifierUtil.hasModifier(field, ModifierType.FINAL)) {
            return;
        }
        ReflectUtil.setAccessible(field);
        try {
            modifiersField = Field.class.getDeclaredField("modifiers");
        }
        catch (NoSuchFieldException e) {
            throw new HutoolException(e, "Field [modifiers] not exist!", new Object[0]);
        }
        try {
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (IllegalAccessException e) {
            throw new HutoolException(e, "IllegalAccess for [{}.{}]", field.getDeclaringClass(), field.getName());
        }
    }

    private static int modifiersToInt(ModifierType ... modifierTypes) {
        int modifier = modifierTypes[0].getValue();
        for (int i = 1; i < modifierTypes.length; ++i) {
            modifier |= modifierTypes[i].getValue();
        }
        return modifier;
    }

    public static enum ModifierType {
        PUBLIC(1),
        PRIVATE(2),
        PROTECTED(4),
        STATIC(8),
        FINAL(16),
        SYNCHRONIZED(32),
        VOLATILE(64),
        TRANSIENT(128),
        NATIVE(256),
        ABSTRACT(1024),
        STRICT(2048);

        private final int value;

        private ModifierType(int modifier) {
            this.value = modifier;
        }

        public int getValue() {
            return this.value;
        }
    }
}

