/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.tree.MapTree;
import org.dromara.hutool.core.tree.TreeBuilder;
import org.dromara.hutool.core.tree.TreeNode;
import org.dromara.hutool.core.tree.TreeNodeConfig;
import org.dromara.hutool.core.tree.parser.DefaultNodeParser;
import org.dromara.hutool.core.tree.parser.NodeParser;
import org.dromara.hutool.core.util.ObjUtil;

public class TreeUtil {
    public static MapTree<Integer> buildSingle(List<TreeNode<Integer>> list) {
        return TreeUtil.buildSingle(list, Integer.valueOf(0));
    }

    public static List<MapTree<Integer>> build(List<TreeNode<Integer>> list) {
        return TreeUtil.build(list, Integer.valueOf(0));
    }

    public static <E> MapTree<E> buildSingle(List<TreeNode<E>> list, E parentId) {
        return TreeUtil.buildSingle(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, new DefaultNodeParser());
    }

    public static <E> List<MapTree<E>> build(List<TreeNode<E>> list, E parentId) {
        return TreeUtil.build(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, new DefaultNodeParser());
    }

    public static <T, E> MapTree<E> buildSingle(List<T> list, E parentId, NodeParser<T, E> nodeParser) {
        return TreeUtil.buildSingle(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, nodeParser);
    }

    public static <T, E> List<MapTree<E>> build(List<T> list, E parentId, NodeParser<T, E> nodeParser) {
        return TreeUtil.build(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, nodeParser);
    }

    public static <T, E> List<MapTree<E>> build(List<T> list, E rootId, TreeNodeConfig treeNodeConfig, NodeParser<T, E> nodeParser) {
        return TreeUtil.buildSingle(list, rootId, treeNodeConfig, nodeParser).getChildren();
    }

    public static <T, E> MapTree<E> buildSingle(List<T> list, E rootId, TreeNodeConfig treeNodeConfig, NodeParser<T, E> nodeParser) {
        return TreeBuilder.of(rootId, treeNodeConfig).append(list, nodeParser).build();
    }

    public static <E> List<MapTree<E>> build(Map<E, MapTree<E>> map, E rootId) {
        return TreeUtil.buildSingle(map, rootId).getChildren();
    }

    public static <E> MapTree<E> buildSingle(Map<E, MapTree<E>> map, E rootId) {
        MapTree<E> tree = CollUtil.getFirstNoneNull(map.values());
        if (null != tree) {
            TreeNodeConfig config = tree.getConfig();
            return TreeBuilder.of(rootId, config).append(map).build();
        }
        return TreeUtil.createEmptyNode(rootId);
    }

    public static <T> MapTree<T> getNode(MapTree<T> node, T id) {
        if (ObjUtil.equals(id, node.getId())) {
            return node;
        }
        List<MapTree<T>> children = node.getChildren();
        if (null == children) {
            return null;
        }
        for (MapTree<T> child : children) {
            MapTree<T> childNode = child.getNode(id);
            if (null == childNode) continue;
            return childNode;
        }
        return null;
    }

    public static <T> List<CharSequence> getParentsName(MapTree<T> node, boolean includeCurrentNode) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        if (null == node) {
            return result;
        }
        if (includeCurrentNode) {
            result.add(node.getName());
        }
        for (MapTree<T> parent = node.getParent(); null != parent; parent = parent.getParent()) {
            result.add(parent.getName());
        }
        return result;
    }

    public static <E> MapTree<E> createEmptyNode(E id) {
        return new MapTree().setId(id);
    }

    public static <E> List<MapTree<E>> toList(MapTree<E> root, boolean broadFirst) {
        if (Objects.isNull(root)) {
            return null;
        }
        ArrayList<MapTree<E>> list = new ArrayList<MapTree<E>>();
        root.walk(list::add, broadFirst);
        return list;
    }
}

