/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.openssl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ByteUtil;

public class SaltMagic {
    public static final byte SALT_LEN = 8;
    public static final byte[] SALTED_MAGIC = "Salted__".getBytes(StandardCharsets.US_ASCII);
    public static final int MAGIC_SALT_LENGTH = SALTED_MAGIC.length + 8;

    public static byte[] getData(byte[] encryptedData) {
        if (ArrayUtil.startWith(encryptedData, SALTED_MAGIC)) {
            return Arrays.copyOfRange(encryptedData, SALTED_MAGIC.length + 8, encryptedData.length);
        }
        return encryptedData;
    }

    public static byte[] getSalt(InputStream in) throws IORuntimeException {
        byte[] headerBytes = new byte[SALTED_MAGIC.length];
        try {
            int readHeaderSize = in.read(headerBytes);
            if (readHeaderSize < headerBytes.length || !Arrays.equals(SALTED_MAGIC, headerBytes)) {
                throw new IORuntimeException("Unexpected magic header " + StrUtil.utf8Str(headerBytes));
            }
            byte[] salt = new byte[8];
            int readSaltSize = in.read(salt);
            if (readSaltSize < salt.length) {
                throw new IORuntimeException("Unexpected salt: " + StrUtil.utf8Str(salt));
            }
            return salt;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static byte[] getSalt(byte[] encryptedData) {
        if (ArrayUtil.startWith(encryptedData, SALTED_MAGIC)) {
            return Arrays.copyOfRange(encryptedData, SALTED_MAGIC.length, MAGIC_SALT_LENGTH);
        }
        return null;
    }

    public static byte[] addMagic(byte[] data, byte[] salt) {
        if (null == salt) {
            return data;
        }
        Assert.isTrue(8 == salt.length);
        return ByteUtil.concat(SALTED_MAGIC, salt, data);
    }

    public static byte[] getSaltedMagic(byte[] salt) {
        return ByteUtil.concat(SALTED_MAGIC, salt);
    }
}

