/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.dromara.hutool.db.ConnectionHolder;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.ThreadLocalConnection;

public class DefaultConnectionHolder
implements ConnectionHolder {
    protected final DataSource ds;

    public DefaultConnectionHolder(DataSource ds) {
        this.ds = ds;
    }

    @Override
    public Connection getConnection() throws DbRuntimeException {
        try {
            return ThreadLocalConnection.INSTANCE.get(this.ds);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    @Override
    public void closeConnection(Connection conn) {
        try {
            if (conn != null && !conn.getAutoCommit()) {
                return;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ThreadLocalConnection.INSTANCE.close(this.ds);
    }
}

