/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.collection.iter.ArrayIter;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.GlobalDbConfig;
import org.dromara.hutool.db.handler.ResultSetUtil;
import org.dromara.hutool.db.handler.RsHandler;
import org.dromara.hutool.db.sql.SqlBuilder;
import org.dromara.hutool.db.sql.SqlLog;
import org.dromara.hutool.db.sql.StatementBuilder;
import org.dromara.hutool.db.sql.StatementWrapper;

public class StatementUtil {
    public static PreparedStatement prepareStatement(Connection conn, SqlBuilder sqlBuilder) throws SQLException {
        return StatementUtil.prepareStatement(conn, sqlBuilder.build(), sqlBuilder.getParamValueArray());
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql, Collection<Object> params) throws SQLException {
        return StatementUtil.prepareStatement(conn, sql, params.toArray(new Object[0]));
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql, Object ... params) throws SQLException {
        return StatementBuilder.of().setConnection(conn).setReturnGeneratedKey(GlobalDbConfig.returnGeneratedKey).setSqlLog(SqlLog.INSTANCE).setSql(sql).setParams(params).build();
    }

    public static PreparedStatement prepareStatementForBatch(Connection conn, String sql, Object[] ... paramsBatch) throws SQLException {
        return StatementUtil.prepareStatementForBatch(conn, sql, new ArrayIter<Object[]>((E[])paramsBatch));
    }

    public static PreparedStatement prepareStatementForBatch(Connection conn, String sql, Iterable<Object[]> paramsBatch) throws SQLException {
        return StatementBuilder.of().setConnection(conn).setReturnGeneratedKey(GlobalDbConfig.returnGeneratedKey).setSqlLog(SqlLog.INSTANCE).setSql(sql).buildForBatch(paramsBatch);
    }

    public static PreparedStatement prepareStatementForBatch(Connection conn, String sql, Iterable<String> fields, Entity ... entities) throws SQLException {
        return StatementBuilder.of().setConnection(conn).setReturnGeneratedKey(GlobalDbConfig.returnGeneratedKey).setSqlLog(SqlLog.INSTANCE).setSql(sql).buildForBatch(fields, entities);
    }

    public static CallableStatement prepareCall(Connection conn, String sql, Object ... params) throws SQLException {
        Assert.notBlank(sql, "Sql String must be not blank!", new Object[0]);
        sql = sql.trim();
        SqlLog.INSTANCE.log(sql, params);
        CallableStatement call = conn.prepareCall(sql);
        StatementUtil.fillArrayParam(call, params);
        return call;
    }

    public static Long getGeneratedKeyOfLong(Statement ps) throws SQLException {
        return StatementUtil.getGeneratedKeys(ps, rs -> {
            Long generatedKey = null;
            if (rs != null && rs.next()) {
                try {
                    generatedKey = rs.getLong(1);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return generatedKey;
        });
    }

    public static List<Object> getGeneratedKeys(Statement ps) throws SQLException {
        return StatementUtil.getGeneratedKeys(ps, ResultSetUtil::handleRowToList);
    }

    public static <T> T getGeneratedKeys(Statement statement, RsHandler<T> rsHandler) throws SQLException {
        try (ResultSet rs = statement.getGeneratedKeys();){
            T t = rsHandler.handle(rs);
            return t;
        }
    }

    public static int getTypeOfNull(PreparedStatement ps, int paramIndex) {
        Assert.notNull(ps, "ps PreparedStatement must be not null in (getTypeOfNull)!", new Object[0]);
        return StatementWrapper.of(ps).getTypeOfNull(paramIndex);
    }

    public static PreparedStatement fillArrayParam(PreparedStatement ps, Object ... params) throws SQLException {
        return StatementWrapper.of(ps).fillArrayParam(params);
    }

    public static PreparedStatement fillParams(PreparedStatement ps, Iterable<?> params) throws SQLException {
        return StatementUtil.fillParams(ps, params, null);
    }

    public static PreparedStatement fillParams(PreparedStatement ps, Iterable<?> params, Map<Integer, Integer> nullTypeCache) throws SQLException {
        return StatementWrapper.of(ps).fillParams(params, nullTypeCache);
    }

    public static void setParam(PreparedStatement ps, int paramIndex, Object param) throws SQLException {
        StatementWrapper.of(ps).setParam(paramIndex, param);
    }
}

