/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.handler;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.bean.PropDesc;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.MethodUtil;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.Entity;

public class ResultSetUtil {
    public static <T> T toBean(int columnCount, ResultSetMetaData meta, ResultSet rs, T bean) throws SQLException {
        return ResultSetUtil.toEntity(columnCount, meta, rs).toBeanIgnoreCase(bean);
    }

    public static <T> T toBean(int columnCount, ResultSetMetaData meta, ResultSet rs, Class<T> beanClass) throws SQLException {
        Assert.notNull(beanClass, "Bean Class must be not null !", new Object[0]);
        if (beanClass.isArray()) {
            Class<?> componentType = beanClass.getComponentType();
            T[] result = ArrayUtil.newArray(componentType, columnCount);
            int i = 0;
            int j = 1;
            while (i < columnCount) {
                result[i] = ResultSetUtil.getColumnValue(rs, j, meta.getColumnType(j), componentType);
                ++i;
                ++j;
            }
            return (T)result;
        }
        if (Iterable.class.isAssignableFrom(beanClass)) {
            Object[] objRow = ResultSetUtil.toBean(columnCount, meta, rs, Object[].class);
            return Convert.convert(beanClass, (Object)objRow);
        }
        if (beanClass.isAssignableFrom(Entity.class)) {
            return (T)ResultSetUtil.toEntity(columnCount, meta, rs);
        }
        if (String.class == beanClass) {
            Object[] objRow = ResultSetUtil.toBean(columnCount, meta, rs, Object[].class);
            return (T)StrUtil.join((CharSequence)", ", objRow);
        }
        T bean = ConstructorUtil.newInstanceIfPossible(beanClass);
        Map<String, PropDesc> propMap = BeanUtil.getBeanDesc(beanClass).getPropMap(true);
        for (int i = 1; i <= columnCount; ++i) {
            Method setter;
            String columnLabel = meta.getColumnLabel(i);
            PropDesc pd = propMap.get(columnLabel);
            if (null == pd) {
                pd = propMap.get(StrUtil.toCamelCase(columnLabel));
            }
            Method method = setter = null == pd ? null : pd.getSetter();
            if (null == setter) continue;
            Object value = ResultSetUtil.getColumnValue(rs, i, meta.getColumnType(i), TypeUtil.getFirstParamType(setter));
            MethodUtil.invokeWithCheck(bean, setter, value);
        }
        return bean;
    }

    public static Entity toEntity(int columnCount, ResultSetMetaData meta, ResultSet rs) throws SQLException {
        return ResultSetUtil.toEntity(columnCount, meta, rs, false);
    }

    public static Entity toEntity(int columnCount, ResultSetMetaData meta, ResultSet rs, boolean caseInsensitive) throws SQLException {
        return ResultSetUtil.toEntity(new Entity(null, caseInsensitive), columnCount, meta, rs, true);
    }

    public static <T extends Entity> T toEntity(T row, int columnCount, ResultSetMetaData meta, ResultSet rs, boolean withMetaInfo) throws SQLException {
        for (int i = 1; i <= columnCount; ++i) {
            int type = meta.getColumnType(i);
            String columnLabel = meta.getColumnLabel(i);
            if ("rownum_".equalsIgnoreCase(columnLabel)) continue;
            row.put((String)columnLabel, (Object)ResultSetUtil.getColumnValue(rs, i, type, null));
        }
        if (withMetaInfo) {
            try {
                row.setTableName(meta.getTableName(1));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            row.setFieldNames(row.keySet());
        }
        return row;
    }

    public static Entity toEntity(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        return ResultSetUtil.toEntity(columnCount, meta, rs);
    }

    public static List<Object> handleRowToList(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        ArrayList<Object> row = new ArrayList<Object>(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            row.add(ResultSetUtil.getColumnValue(rs, i, meta.getColumnType(i), null));
        }
        return row;
    }

    public static <T extends Collection<Entity>> T toEntityList(ResultSet rs, T collection) throws SQLException {
        return ResultSetUtil.toEntityList(rs, collection, false);
    }

    public static <T extends Collection<Entity>> T toEntityList(ResultSet rs, T collection, boolean caseInsensitive) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        while (rs.next()) {
            collection.add((Entity)ResultSetUtil.toEntity(columnCount, meta, rs, caseInsensitive));
        }
        return collection;
    }

    public static <E, T extends Collection<E>> T toBeanList(ResultSet rs, T collection, Class<E> elementBeanType) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        while (rs.next()) {
            collection.add(ResultSetUtil.toBean(columnCount, meta, rs, elementBeanType));
        }
        return collection;
    }

    public static Long toLong(ResultSet rs) throws SQLException {
        Long generatedKey = null;
        if (rs != null && rs.next()) {
            try {
                generatedKey = rs.getLong(1);
            }
            catch (DbRuntimeException dbRuntimeException) {
                // empty catch block
            }
        }
        return generatedKey;
    }

    private static Object getColumnValue(ResultSet rs, int columnIndex, int type, Type targetColumnType) throws SQLException {
        Object rawValue = null;
        switch (type) {
            case 93: {
                try {
                    rawValue = rs.getTimestamp(columnIndex);
                }
                catch (SQLException sQLException) {}
                break;
            }
            case 92: {
                rawValue = rs.getTime(columnIndex);
                break;
            }
            default: {
                rawValue = rs.getObject(columnIndex);
            }
        }
        if (null == targetColumnType || Object.class == targetColumnType) {
            return rawValue;
        }
        return Convert.convert(targetColumnType, rawValue);
    }
}

