/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.sql;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.text.StrUtil;

public class NamedSql {
    private static final char[] NAME_START_CHARS = new char[]{':', '@', '?'};
    private String sql;
    private final List<Object> params = new LinkedList<Object>();

    public NamedSql(String namedSql, Map<String, Object> paramMap) {
        this.parse(namedSql, paramMap);
    }

    public String getSql() {
        return this.sql;
    }

    public Object[] getParams() {
        return this.params.toArray(new Object[0]);
    }

    public List<Object> getParamList() {
        return this.params;
    }

    private void parse(String namedSql, Map<String, Object> paramMap) {
        if (MapUtil.isEmpty(paramMap)) {
            this.sql = namedSql;
            return;
        }
        int len = namedSql.length();
        StringBuilder name = new StringBuilder();
        StringBuilder sqlBuilder = new StringBuilder();
        Character nameStartChar = null;
        for (int i = 0; i < len; ++i) {
            char c = namedSql.charAt(i);
            if (ArrayUtil.contains(NAME_START_CHARS, c)) {
                this.replaceVar(nameStartChar, name, sqlBuilder, paramMap);
                nameStartChar = Character.valueOf(c);
                continue;
            }
            if (null != nameStartChar) {
                if (NamedSql.isGenerateChar(c)) {
                    name.append(c);
                    continue;
                }
                this.replaceVar(nameStartChar, name, sqlBuilder, paramMap);
                nameStartChar = null;
                sqlBuilder.append(c);
                continue;
            }
            sqlBuilder.append(c);
        }
        if (name.length() > 0) {
            this.replaceVar(nameStartChar, name, sqlBuilder, paramMap);
        }
        this.sql = sqlBuilder.toString();
    }

    private void replaceVar(Character nameStartChar, StringBuilder name, StringBuilder sqlBuilder, Map<String, Object> paramMap) {
        if (name.length() == 0) {
            if (null != nameStartChar) {
                sqlBuilder.append(nameStartChar);
            }
            return;
        }
        String nameStr = name.toString();
        if (paramMap.containsKey(nameStr)) {
            Object[] paramValue = paramMap.get(nameStr);
            if ((paramValue instanceof Collection || ArrayUtil.isArray(paramValue)) && StrUtil.containsIgnoreCase(sqlBuilder, "in")) {
                if (paramValue instanceof Collection) {
                    paramValue = ((Collection)paramValue).toArray();
                }
                int length = ArrayUtil.length(paramValue);
                for (int i = 0; i < length; ++i) {
                    if (0 != i) {
                        sqlBuilder.append(',');
                    }
                    sqlBuilder.append('?');
                    this.params.add(ArrayUtil.get(paramValue, i));
                }
            } else {
                sqlBuilder.append('?');
                this.params.add(paramValue);
            }
        } else {
            sqlBuilder.append(nameStartChar).append((CharSequence)name);
        }
        name.setLength(0);
    }

    private static boolean isGenerateChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c >= '0' && c <= '9';
    }
}

