/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.qrcode;

import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import org.dromara.hutool.core.codec.Encoder;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.extra.qrcode.QrCodeException;
import org.dromara.hutool.extra.qrcode.QrConfig;

public class QrEncoder
implements Encoder<CharSequence, BitMatrix> {
    private final QrConfig config;

    public static QrEncoder of(QrConfig config) {
        return new QrEncoder(config);
    }

    public QrEncoder(QrConfig config) {
        this.config = ObjUtil.defaultIfNull(config, QrConfig::of);
    }

    @Override
    public BitMatrix encode(CharSequence content) {
        BitMatrix bitMatrix;
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        try {
            bitMatrix = multiFormatWriter.encode(StrUtil.toString(content), this.config.format, this.config.width, this.config.height, this.config.toHints());
        }
        catch (WriterException e) {
            throw new QrCodeException(e);
        }
        return bitMatrix;
    }
}

