/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.template.engine;

import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.spi.SpiUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.template.TemplateConfig;
import org.dromara.hutool.extra.template.TemplateException;
import org.dromara.hutool.extra.template.engine.TemplateEngine;
import org.dromara.hutool.log.StaticLog;

public class TemplateEngineFactory {
    public static TemplateEngine getEngine() {
        return Singleton.get(TemplateEngine.class.getName(), TemplateEngineFactory::createEngine);
    }

    public static TemplateEngine createEngine() {
        return TemplateEngineFactory.createEngine(TemplateConfig.DEFAULT);
    }

    public static TemplateEngine createEngine(TemplateConfig config) {
        TemplateEngine engine = TemplateEngineFactory.doCreateEngine(config);
        StaticLog.debug("Use [{}] Engine As Default.", StrUtil.removeSuffix(engine.getClass().getSimpleName(), "Engine"));
        return engine;
    }

    private static TemplateEngine doCreateEngine(TemplateConfig config) {
        Class<? extends TemplateEngine> customEngineClass = config.getCustomEngine();
        TemplateEngine engine = null != customEngineClass ? ConstructorUtil.newInstance(customEngineClass, new Object[0]) : SpiUtil.loadFirstAvailable(TemplateEngine.class);
        if (null != engine) {
            return engine.init(config);
        }
        throw new TemplateException("No template found! Please add one of template jar to your project !");
    }
}

