/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine;

import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.spi.SpiUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.client.ClientConfig;
import org.dromara.hutool.http.client.engine.ClientEngine;
import org.dromara.hutool.log.StaticLog;

public class ClientEngineFactory {
    public static ClientEngine getEngine() {
        return Singleton.get(ClientEngine.class.getName(), ClientEngineFactory::createEngine);
    }

    public static ClientEngine createEngine(ClientConfig config) {
        return ClientEngineFactory.createEngine().init(config);
    }

    public static ClientEngine createEngine() {
        ClientEngine engine = ClientEngineFactory.doCreateEngine();
        StaticLog.debug("Use [{}] Http Engine As Default.", StrUtil.removeSuffix(engine.getClass().getSimpleName(), "Engine"));
        return engine;
    }

    private static ClientEngine doCreateEngine() {
        ClientEngine engine = SpiUtil.loadFirstAvailable(ClientEngine.class);
        if (null != engine) {
            return engine;
        }
        throw new HttpException("No http jar found !Please add one of it to your project !");
    }
}

