/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.setting;

import java.util.Map;
import org.dromara.hutool.core.io.file.FileNameUtil;
import org.dromara.hutool.core.io.resource.NoResourceException;
import org.dromara.hutool.core.map.SafeConcurrentHashMap;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.setting.Setting;

public class SettingUtil {
    private static final Map<String, Setting> SETTING_MAP = new SafeConcurrentHashMap<String, Setting>();

    public static Setting get(String name) {
        return SETTING_MAP.computeIfAbsent(name, filePath -> {
            String extName = FileNameUtil.extName(filePath);
            if (StrUtil.isEmpty(extName)) {
                filePath = filePath + "." + "setting";
            }
            return new Setting((String)filePath, true);
        });
    }

    public static Setting getFirstFound(String ... names) {
        for (String name : names) {
            try {
                return SettingUtil.get(name);
            }
            catch (NoResourceException noResourceException) {
            }
        }
        return null;
    }
}

