/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl;

import java.util.regex.Pattern;
import org.neo4j.cypherdsl.CypherQuery;
import org.neo4j.cypherdsl.Property;
import org.neo4j.cypherdsl.expression.NumericExpression;
import org.neo4j.cypherdsl.expression.ReferenceExpression;
import org.neo4j.cypherdsl.expression.StringExpression;
import org.neo4j.cypherdsl.query.AbstractExpression;
import org.neo4j.cypherdsl.query.Query;
import org.neo4j.cypherdsl.query.Value;

public class Identifier
extends Value
implements ReferenceExpression {
    private static Pattern simpleName = Pattern.compile("\\p{Alpha}\\w*");

    Identifier(String name) {
        super(new IdentifierExpression(name));
    }

    public Property property(String name) {
        return this.property(CypherQuery.identifier(name));
    }

    public Property property(Identifier name) {
        Query.checkNull(name, "Name");
        return new Property(this, name);
    }

    public StringExpression string(String name) {
        return this.string(CypherQuery.identifier(name));
    }

    public StringExpression string(Identifier name) {
        Query.checkNull(name, "Name");
        return new Property(this, name);
    }

    public NumericExpression number(String name) {
        return this.number(CypherQuery.identifier(name));
    }

    public NumericExpression number(Identifier name) {
        Query.checkNull(name, "Name");
        return new Property(this, name);
    }

    private static class IdentifierExpression
    extends AbstractExpression {
        private String name;

        private IdentifierExpression(String name) {
            this.name = name;
        }

        @Override
        public void asString(StringBuilder builder) {
            if (simpleName.matcher(this.name).matches()) {
                builder.append(this.name);
            } else {
                builder.append('`').append(this.name).append('`');
            }
        }
    }
}

