/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl;

import org.neo4j.cypherdsl.query.AbstractExpression;
import org.neo4j.cypherdsl.query.Value;

public class Literal
extends Value {
    Literal(Object value) {
        super(new LiteralExpression(value));
    }

    private static class LiteralExpression
    extends AbstractExpression {
        public Object value;

        private LiteralExpression(Object value) {
            this.value = value;
        }

        @Override
        public void asString(StringBuilder builder) {
            if (this.value instanceof String) {
                if (builder.toString().endsWith("/") || builder.toString().endsWith("(?i)")) {
                    builder.append(this.value.toString().replaceAll("/", "\\\\/"));
                } else {
                    builder.append("\"").append(this.value.toString().replace("\\", "\\\\").replace("\"", "\\\"")).append("\"");
                }
            } else {
                builder.append(this.value.toString());
            }
        }

        @Override
        public String toString() {
            return this.value.toString();
        }
    }
}

