/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.neo4j.cypherdsl.CypherQuery;
import org.neo4j.cypherdsl.Identifier;
import org.neo4j.cypherdsl.Parameter;
import org.neo4j.cypherdsl.PathRelationship;
import org.neo4j.cypherdsl.expression.Expression;
import org.neo4j.cypherdsl.expression.PathExpression;
import org.neo4j.cypherdsl.query.AbstractExpression;
import org.neo4j.cypherdsl.query.Direction;
import org.neo4j.cypherdsl.query.PropertyValue;
import org.neo4j.cypherdsl.query.PropertyValues;

public class Path
extends AbstractExpression
implements PathExpression {
    private Expression node;
    private Expression nodePropertyValues;
    private PathRelationship relationship;

    Path(Expression node, PathRelationship relationship) {
        this.node = node;
        this.relationship = relationship;
    }

    public Path values(PropertyValue ... propertyValues) {
        this.nodePropertyValues = new PropertyValues(Arrays.asList(propertyValues));
        return this;
    }

    public Path values(Iterable<PropertyValue> propertyValues) {
        this.nodePropertyValues = new PropertyValues(propertyValues);
        return this;
    }

    public Path values(Parameter propertyValues) {
        this.nodePropertyValues = propertyValues;
        return this;
    }

    public PathRelationship out() {
        return new PathRelationship(this, Direction.OUT, Collections.<Identifier>emptyList());
    }

    public PathRelationship out(String ... relationships) {
        return new PathRelationship(this, Direction.OUT, Arrays.asList(CypherQuery.identifiers(relationships)));
    }

    public PathRelationship out(Identifier ... relationships) {
        return new PathRelationship(this, Direction.OUT, Arrays.asList(relationships));
    }

    public PathRelationship out(Enum<?> ... relationships) {
        ArrayList<Identifier> relationshipNames = new ArrayList<Identifier>();
        for (Enum<?> relationship : relationships) {
            relationshipNames.add(CypherQuery.identifier(relationship.name()));
        }
        return new PathRelationship(this, Direction.OUT, relationshipNames);
    }

    public PathRelationship in() {
        return new PathRelationship(this, Direction.IN, Collections.<Identifier>emptyList());
    }

    public PathRelationship in(String ... relationships) {
        return new PathRelationship(this, Direction.IN, Arrays.asList(CypherQuery.identifiers(relationships)));
    }

    public PathRelationship in(Identifier ... relationships) {
        return new PathRelationship(this, Direction.IN, Arrays.asList(relationships));
    }

    public PathRelationship in(Enum<?> ... relationships) {
        ArrayList<Identifier> relationshipNames = new ArrayList<Identifier>();
        for (Enum<?> relationship : relationships) {
            relationshipNames.add(CypherQuery.identifier(relationship.name()));
        }
        return new PathRelationship(this, Direction.IN, relationshipNames);
    }

    public PathRelationship both() {
        return new PathRelationship(this, Direction.BOTH, Collections.<Identifier>emptyList());
    }

    public PathRelationship both(String ... relationships) {
        return new PathRelationship(this, Direction.BOTH, Arrays.asList(CypherQuery.identifiers(relationships)));
    }

    public PathRelationship both(Identifier ... relationships) {
        return new PathRelationship(this, Direction.BOTH, Arrays.asList(relationships));
    }

    public PathRelationship both(Enum<?> ... relationships) {
        ArrayList<Identifier> relationshipNames = new ArrayList<Identifier>();
        for (Enum<?> relationship : relationships) {
            relationshipNames.add(CypherQuery.identifier(relationship.name()));
        }
        return new PathRelationship(this, Direction.BOTH, relationshipNames);
    }

    @Override
    public void asString(StringBuilder builder) {
        if (this.relationship != null) {
            this.relationship.asString(builder);
        }
        builder.append('(');
        if (this.node != null) {
            this.node.asString(builder);
            if (this.nodePropertyValues != null) {
                builder.append(' ');
                this.nodePropertyValues.asString(builder);
            }
        } else if (this.nodePropertyValues != null) {
            this.nodePropertyValues.asString(builder);
        }
        builder.append(')');
    }
}

