/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl;

import java.io.Serializable;
import java.util.Arrays;
import org.neo4j.cypherdsl.AsString;
import org.neo4j.cypherdsl.CypherQuery;
import org.neo4j.cypherdsl.Identifier;
import org.neo4j.cypherdsl.Path;
import org.neo4j.cypherdsl.expression.Expression;
import org.neo4j.cypherdsl.query.Direction;
import org.neo4j.cypherdsl.query.PropertyValue;
import org.neo4j.cypherdsl.query.PropertyValues;
import org.neo4j.cypherdsl.query.Query;

public class PathRelationship
implements AsString,
Serializable,
Cloneable {
    public Path leftNode;
    public Direction direction = null;
    public Identifier as;
    public Iterable<Identifier> relationships;
    public PropertyValues relationshipPropertyValues;
    public boolean optional;
    public Integer minHops;
    public Integer maxHops;

    PathRelationship(Path leftNode, Direction direction, Iterable<Identifier> relationships) {
        this.leftNode = leftNode;
        this.direction = direction;
        this.relationships = relationships;
    }

    public PathRelationship values(PropertyValue ... propertyValues) {
        this.relationshipPropertyValues = new PropertyValues(Arrays.asList(propertyValues));
        return this;
    }

    public PathRelationship values(Iterable<PropertyValue> propertyValues) {
        this.relationshipPropertyValues = new PropertyValues(propertyValues);
        return this;
    }

    public PathRelationship as(String name) {
        return this.as(CypherQuery.identifier(name));
    }

    public PathRelationship as(Identifier name) {
        Query.checkNull(name, "Name");
        this.as = name;
        return this;
    }

    public PathRelationship optional() {
        this.optional = true;
        return this;
    }

    public PathRelationship hops(Integer minHops, Integer maxHops) {
        if (minHops != null && minHops < 0) {
            throw new IllegalArgumentException("Minimum number of hops must be over zero");
        }
        if (maxHops != null && maxHops < 0) {
            throw new IllegalArgumentException("Maximum number of hops must be over zero");
        }
        this.minHops = minHops;
        this.maxHops = maxHops;
        return this;
    }

    public Path node() {
        return new Path(null, this);
    }

    public Path node(String id) {
        return this.node(CypherQuery.identifier(id));
    }

    public Path node(Expression id) {
        return new Path(id, this);
    }

    @Override
    public void asString(StringBuilder builder) {
        this.leftNode.asString(builder);
        builder.append(this.direction.equals((Object)Direction.IN) ? "<-" : "-");
        boolean hasRelationships = this.relationships.iterator().hasNext();
        if (this.as != null || hasRelationships || this.optional || this.minHops != null || this.maxHops != null) {
            builder.append('[');
            if (this.as != null) {
                this.as.asString(builder);
            }
            if (this.optional) {
                builder.append('?');
            }
            if (hasRelationships) {
                builder.append(':');
                String or = "";
                for (Identifier relationship : this.relationships) {
                    builder.append(or);
                    relationship.asString(builder);
                    or = "|";
                }
                if (this.relationshipPropertyValues != null) {
                    builder.append(' ');
                    this.relationshipPropertyValues.asString(builder);
                }
            }
            if (this.minHops != null || this.maxHops != null) {
                builder.append('*');
                if (this.minHops != null) {
                    builder.append(this.minHops);
                }
                builder.append("..");
                if (this.maxHops != null) {
                    builder.append(this.maxHops);
                }
            }
            builder.append(']');
        }
        builder.append(this.direction.equals((Object)Direction.OUT) ? "->" : "-");
    }
}

