/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.query;

import org.neo4j.cypherdsl.CypherQuery;
import org.neo4j.cypherdsl.expression.BooleanExpression;
import org.neo4j.cypherdsl.expression.CollectionExpression;
import org.neo4j.cypherdsl.expression.Expression;
import org.neo4j.cypherdsl.query.Operator;
import org.neo4j.cypherdsl.query.Value;

public abstract class AbstractExpression
implements Expression {
    @Override
    public BooleanExpression eq(Object expression) {
        return new Value(new Operator(this, "="), CypherQuery.literal(expression));
    }

    @Override
    public BooleanExpression eq(Expression expression) {
        return new Value(new Operator(this, "="), expression);
    }

    @Override
    public BooleanExpression ne(Object expression) {
        return new Value(new Operator(this, "<>"), CypherQuery.literal(expression));
    }

    @Override
    public BooleanExpression ne(Expression expression) {
        return new Value(new Operator(this, "<>"), expression);
    }

    public BooleanExpression and(BooleanExpression expression) {
        return new CypherQuery.And(new BooleanExpression[]{(BooleanExpression)((Object)this), expression});
    }

    public BooleanExpression or(BooleanExpression expression) {
        return new CypherQuery.Or(new BooleanExpression[]{(BooleanExpression)((Object)this), expression});
    }

    public BooleanExpression in(CollectionExpression collection) {
        return new Value(new Operator(this, " IN "), collection);
    }

    public CollectionExpression union(CollectionExpression expression) {
        return new Value(new Operator(this, "+"), expression);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.asString(builder);
        return builder.toString();
    }
}

