/*
 * Decompiled with CFR 0.152.
 */
package org.noear.redisx;

import java.util.HashSet;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.noear.redisx.RedisClusterSession;
import org.noear.redisx.RedisSession;
import org.noear.redisx.RedisSingleSession;
import org.noear.redisx.plus.RedisAtomic;
import org.noear.redisx.plus.RedisBucket;
import org.noear.redisx.plus.RedisBus;
import org.noear.redisx.plus.RedisHash;
import org.noear.redisx.plus.RedisId;
import org.noear.redisx.plus.RedisList;
import org.noear.redisx.plus.RedisLock;
import org.noear.redisx.plus.RedisQueue;
import org.noear.redisx.utils.TextUtil;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisClient {
    private JedisPool jedisPool;
    private JedisCluster jedisCluster;

    public RedisClient(Properties prop) {
        String db = prop.getProperty("db");
        if (TextUtil.isEmpty(db)) {
            this.initDo(prop, 0, 0);
        } else {
            this.initDo(prop, Integer.parseInt(db), 0);
        }
    }

    public RedisClient(Properties prop, int db) {
        this.initDo(prop, db, 0);
    }

    public RedisClient(Properties prop, int db, int maxTotal) {
        this.initDo(prop, db, maxTotal);
    }

    private void initDo(Properties prop, int db, int maxTotal) {
        int minIdle;
        int soTimeout;
        String server = prop.getProperty("server");
        String user = prop.getProperty("user");
        String password = prop.getProperty("password");
        String maxWaitMillisStr = prop.getProperty("maxWaitMillis");
        String maxTotalStr = prop.getProperty("maxTotal");
        String maxIdleStr = prop.getProperty("maxIdle");
        String connectionTimeoutStr = prop.getProperty("connectionTimeout");
        String soTimeoutStr = prop.getProperty("soTimeout");
        String maxAttemptsStr = prop.getProperty("maxAttempts");
        long maxWaitMillis = TextUtil.isEmpty(maxWaitMillisStr) ? 0L : Long.parseLong(maxWaitMillisStr);
        int maxAttempts = TextUtil.isEmpty(maxAttemptsStr) ? 0 : Integer.parseInt(maxAttemptsStr);
        int maxIdle = TextUtil.isEmpty(maxIdleStr) ? 0 : Integer.parseInt(maxIdleStr);
        int connectionTimeout = TextUtil.isEmpty(connectionTimeoutStr) ? 0 : Integer.parseInt(connectionTimeoutStr);
        int n = soTimeout = TextUtil.isEmpty(soTimeoutStr) ? 0 : Integer.parseInt(soTimeoutStr);
        if (maxTotal == 0) {
            maxTotal = TextUtil.isEmpty(maxTotalStr) ? 0 : Integer.parseInt(maxTotalStr);
        }
        JedisPoolConfig config = new JedisPoolConfig();
        if (db < 0) {
            db = 0;
        }
        if (maxTotal < 20) {
            maxTotal = 200;
        }
        if (maxIdle == 0) {
            maxIdle = maxTotal;
        }
        if ((minIdle = maxTotal / 100) < 5) {
            minIdle = 5;
        }
        if (maxWaitMillis < 3000L) {
            maxWaitMillis = 3000L;
        }
        if (maxAttempts == 0) {
            maxAttempts = 5;
        }
        if (connectionTimeout == 0) {
            connectionTimeout = 3000;
        }
        if (soTimeout == 0) {
            soTimeout = connectionTimeout;
        }
        config.setMaxTotal(maxTotal);
        config.setMaxIdle(maxIdle);
        config.setMinIdle(minIdle);
        config.setMaxWaitMillis(maxWaitMillis);
        config.setTestOnBorrow(false);
        config.setTestOnReturn(false);
        if (server.contains(",")) {
            HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
            for (String fqdn : server.split(",")) {
                if (TextUtil.isEmpty(fqdn)) continue;
                String[] info = fqdn.split(":");
                nodes.add(new HostAndPort(info[0], Integer.parseInt(info[1])));
            }
            this.jedisCluster = TextUtil.isEmpty(user) ? new JedisCluster(nodes, connectionTimeout, soTimeout, maxAttempts, password, (GenericObjectPoolConfig)config) : new JedisCluster(nodes, connectionTimeout, soTimeout, maxAttempts, user, password, null, (GenericObjectPoolConfig)config);
        } else {
            String[] ss = server.split(":");
            if ("".equals(password)) {
                password = null;
            }
            this.jedisPool = TextUtil.isEmpty(user) ? new JedisPool((GenericObjectPoolConfig)config, ss[0], Integer.parseInt(ss[1]), connectionTimeout, password, db) : new JedisPool((GenericObjectPoolConfig)config, ss[0], Integer.parseInt(ss[1]), connectionTimeout, user, password, db);
        }
    }

    @Deprecated
    public void open0(Consumer<RedisSession> using) {
        this.open(using);
    }

    @Deprecated
    public <T> T open1(Function<RedisSession, T> using) {
        return this.openAndGet(using);
    }

    public void open(Consumer<RedisSession> using) {
        try (RedisSession session = this.openSession();){
            using.accept(session);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T openAndGet(Function<RedisSession, T> using) {
        try (RedisSession session = this.openSession();){
            RedisSession redisSession = using.apply(session);
            return (T)redisSession;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public RedisSession openSession() {
        if (this.jedisPool != null) {
            Jedis jx = this.jedisPool.getResource();
            return new RedisSingleSession(jx);
        }
        return new RedisClusterSession(this.jedisCluster);
    }

    public RedisAtomic getAtomic(String atomicName) {
        return new RedisAtomic(this, atomicName);
    }

    public RedisBus getBus() {
        return new RedisBus(this);
    }

    public RedisBucket getBucket() {
        return new RedisBucket(this);
    }

    public RedisHash getHash(String hashName) {
        return new RedisHash(this, hashName);
    }

    public RedisHash getHash(String hashName, int inSeconds) {
        return new RedisHash(this, hashName, inSeconds);
    }

    public RedisLock getLock(String lockName) {
        return new RedisLock(this, lockName);
    }

    public RedisQueue getQueue(String queueName) {
        return new RedisQueue(this, queueName);
    }

    public RedisList getList(String listName) {
        return new RedisList(this, listName);
    }

    public RedisId getId(String idName) {
        return new RedisId(this, idName);
    }
}

