/*
 * Decompiled with CFR 0.152.
 */
package org.noear.redisx;

import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.noear.redisx.RedisSession;
import org.noear.redisx.model.LocalHash;
import org.noear.redisx.utils.AssertUtil;
import org.noear.redisx.utils.TextUtil;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.params.SetParams;

public class RedisClusterSession
implements RedisSession {
    private static final String LOCK_SUCCEED = "OK";
    private final JedisCluster cluster;
    private boolean _close = false;
    private String _key;
    private long _seconds;

    protected RedisClusterSession(JedisCluster jedis) {
        this.cluster = jedis;
    }

    @Override
    public void close() throws Exception {
        if (this._close) {
            return;
        }
        this.cluster.close();
        this._close = true;
    }

    @Override
    public Jedis jedis() {
        return null;
    }

    @Override
    public Long deleteKeys(Collection<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return 0L;
        }
        String[] keyAry = new String[keys.size()];
        return ((JedisPool)this.cluster.getClusterNodes().get(0)).getResource().del(keys.toArray(keyAry));
    }

    @Override
    public Long existsKeys(Collection<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return 0L;
        }
        String[] keyAry = new String[keys.size()];
        return this.cluster.exists(keys.toArray(keyAry));
    }

    @Override
    public RedisClusterSession key(String key) {
        AssertUtil.notEmpty(key, "redis key cannot be empty");
        this._key = key;
        return this;
    }

    @Override
    public RedisClusterSession expire(int seconds) {
        this._seconds = seconds;
        return this;
    }

    @Override
    public RedisClusterSession persist() {
        this._seconds = -1L;
        return this;
    }

    private void expirePush() {
        if (this._seconds > 0L) {
            this.cluster.expire(this._key, this._seconds);
        }
        if (this._seconds < 0L) {
            this.cluster.persist(this._key);
        }
    }

    @Override
    public void delay() {
        this.expirePush();
    }

    @Override
    public void delay(int seconds) {
        this._seconds = seconds;
        this.expirePush();
    }

    @Override
    public List<String> scan(String keyPattern, int count) {
        String cursor = ScanParams.SCAN_POINTER_START;
        ScanParams p = new ScanParams();
        p.count(Integer.valueOf(count));
        p.match(keyPattern);
        return this.cluster.scan(cursor, p).getResult();
    }

    @Override
    public boolean match(String keyPattern) {
        List<String> temp = this.scan(keyPattern, 1);
        return temp != null && temp.size() > 0;
    }

    @Override
    public Boolean exists() {
        return this.cluster.exists(this._key);
    }

    @Override
    public Boolean delete() {
        return this.cluster.del(this._key) > 0L;
    }

    @Override
    public void rename(String newKey) {
        this.cluster.rename(this._key, newKey);
    }

    @Override
    public long ttl() {
        return this.cluster.ttl(this._key);
    }

    @Override
    public Set<String> keys(String pattern) {
        return this.cluster.keys(pattern);
    }

    @Override
    public RedisClusterSession set(String val) {
        AssertUtil.notNull(val, "redis value cannot be null");
        this.cluster.set(this._key, val);
        this.expirePush();
        return this;
    }

    @Override
    public RedisClusterSession set(long val) {
        return this.set(String.valueOf(val));
    }

    @Override
    public String get() {
        return this.cluster.get(this._key);
    }

    @Override
    public long getAsLong() {
        String temp = this.get();
        if (TextUtil.isEmpty(temp)) {
            return 0L;
        }
        return Long.parseLong(temp);
    }

    @Override
    public List<String> getMore(String ... keys) {
        return this.cluster.mget(keys);
    }

    @Override
    public long incr(long num) {
        long val = this.cluster.incrBy(this._key, num);
        this.expirePush();
        return val;
    }

    @Override
    public long incr() {
        long val = this.cluster.incr(this._key);
        this.expirePush();
        return val;
    }

    @Override
    public long decr() {
        long val = this.cluster.decr(this._key);
        this.expirePush();
        return val;
    }

    @Override
    public boolean lock(String val) {
        SetParams options = new SetParams().nx().ex(this._seconds);
        String rst = this.cluster.set(this._key, val, options);
        return LOCK_SUCCEED.equals(rst);
    }

    @Override
    public boolean lock() {
        return this.lock(System.currentTimeMillis() + "");
    }

    @Override
    public Boolean hashHas(String field) {
        return this.cluster.hexists(this._key, field);
    }

    @Override
    public List<Map.Entry<String, String>> hashScan(String fieldPattern, int count) {
        String cursor = ScanParams.SCAN_POINTER_START;
        ScanParams p = new ScanParams();
        p.count(Integer.valueOf(count));
        p.match(fieldPattern);
        return this.cluster.hscan(this._key.getBytes(StandardCharsets.UTF_8), cursor.getBytes(StandardCharsets.UTF_8), p).getResult().stream().map(item -> new AbstractMap.SimpleEntry<String, String>(new String((byte[])item.getKey()), new String((byte[])item.getValue()))).collect(Collectors.toList());
    }

    @Override
    public boolean hashMatch(String fieldPattern) {
        List<Map.Entry<String, String>> temp = this.hashScan(fieldPattern, 1);
        return temp != null && temp.size() > 0;
    }

    @Override
    public long hashDel(String ... fields) {
        return this.cluster.hdel(this._key, fields);
    }

    @Override
    public RedisClusterSession hashSet(String field, String val) {
        this.cluster.hset(this._key, field, val);
        this.expirePush();
        return this;
    }

    @Override
    public RedisClusterSession hashSet(String field, long val) {
        return this.hashSet(field, String.valueOf(val));
    }

    @Override
    public RedisClusterSession hashSetAll(Map<? extends String, ? extends String> map) {
        map.forEach((k, v) -> this.cluster.hset(this._key, k, v));
        this.expirePush();
        return this;
    }

    @Override
    public long hashIncr(String field, long num) {
        long val = this.cluster.hincrBy(this._key, field, num);
        this.expirePush();
        return val;
    }

    @Override
    public String hashGet(String field) {
        return this.cluster.hget(this._key, field);
    }

    @Override
    public long hashGetAsLong(String field) {
        String temp = this.hashGet(field);
        if (TextUtil.isEmpty(temp)) {
            return 0L;
        }
        return Long.parseLong(temp);
    }

    @Override
    public List<String> hashGetMore(String ... fields) {
        return this.cluster.hmget(this._key, fields);
    }

    @Override
    public LocalHash hashGetAll() {
        return new LocalHash(this.cluster.hgetAll(this._key));
    }

    @Override
    public Set<String> hashGetAllKeys() {
        return this.cluster.hkeys(this._key);
    }

    @Override
    public List<String> hashGetAllValues() {
        return this.cluster.hvals(this._key);
    }

    @Override
    public long hashLen() {
        return this.cluster.hlen(this._key);
    }

    @Override
    public RedisClusterSession listAdd(String item) {
        this.cluster.lpush(this._key, new String[]{item});
        this.expirePush();
        return this;
    }

    @Override
    public RedisClusterSession listAdd(long item) {
        return this.listAdd(String.valueOf(item));
    }

    @Override
    public RedisClusterSession listSet(int index, String newValue) {
        this.cluster.lset(this._key, (long)index, newValue);
        this.expirePush();
        return this;
    }

    @Override
    public RedisClusterSession listDel(String item, int count) {
        this.cluster.lrem(this._key, (long)count, item);
        this.expirePush();
        return this;
    }

    @Override
    public RedisClusterSession listDel(String item) {
        return this.listDel(item, 0);
    }

    @Override
    public RedisClusterSession listDelRange(Collection<? extends String> items) {
        for (String string : items) {
            this.cluster.lrem(this._key, 0L, string);
        }
        this.expirePush();
        return this;
    }

    @Override
    public RedisClusterSession listAddRange(Collection<? extends String> items) {
        for (String string : items) {
            this.cluster.lpush(this._key, new String[]{string});
        }
        this.expirePush();
        return this;
    }

    @Override
    public String listPop() {
        return this.cluster.rpop(this._key);
    }

    @Override
    public String listPeek() {
        return this.cluster.lindex(this._key, -1L);
    }

    @Override
    public String listGet(int index) {
        return this.cluster.lindex(this._key, (long)index);
    }

    @Override
    public List<String> listGetRange(int start, int end) {
        return this.cluster.lrange(this._key, (long)start, (long)end);
    }

    @Override
    public List<String> listGetAll() {
        return this.cluster.lrange(this._key, 0L, -1L);
    }

    @Override
    public long listLen() {
        return this.cluster.llen(this._key);
    }

    @Override
    public long setAdd(String item) {
        long tmp = this.cluster.sadd(this._key, new String[]{item});
        this.expirePush();
        return tmp;
    }

    @Override
    public long setDel(String item) {
        long tmp = this.cluster.srem(this._key, new String[]{item});
        return tmp;
    }

    @Override
    public RedisClusterSession setAddRange(Collection<String> items) {
        this.cluster.sadd(this._key, items.toArray(new String[items.size()]));
        this.expirePush();
        return this;
    }

    @Override
    public long setLen() {
        return this.cluster.scard(this._key);
    }

    @Override
    public String setPop() {
        return this.cluster.spop(this._key);
    }

    @Override
    public List<String> setGet(int count) {
        return this.cluster.srandmember(this._key, count);
    }

    @Override
    public List<String> setScan(String itemPattern, int count) {
        String cursor = ScanParams.SCAN_POINTER_START;
        ScanParams p = new ScanParams();
        p.count(Integer.valueOf(count));
        p.match(itemPattern);
        return this.cluster.sscan(this._key.getBytes(StandardCharsets.UTF_8), cursor.getBytes(StandardCharsets.UTF_8), p).getResult().stream().map(String::new).collect(Collectors.toList());
    }

    @Override
    public boolean setMatch(String itemPattern) {
        List<String> temp = this.setScan(itemPattern, 1);
        return temp != null && temp.size() > 0;
    }

    @Override
    public RedisClusterSession zsetAdd(double score, String item) {
        this.cluster.zadd(this._key, score, item);
        this.expirePush();
        return this;
    }

    @Override
    public long zsetDel(String ... items) {
        long tmp = this.cluster.zrem(this._key, items);
        return tmp;
    }

    @Override
    public long zsetLen() {
        return this.cluster.zcard(this._key);
    }

    @Override
    public Set<String> zsetGet(long start, long end) {
        return this.cluster.zrange(this._key, start, end);
    }

    @Override
    public long zsetIdx(String item) {
        Long tmp = this.cluster.zrank(this._key, item);
        if (tmp == null) {
            return -1L;
        }
        return tmp;
    }

    @Override
    public List<Tuple> zsetScan(String itemPattern, int count) {
        String cursor = ScanParams.SCAN_POINTER_START;
        ScanParams p = new ScanParams();
        p.count(Integer.valueOf(count));
        p.match(itemPattern);
        return this.cluster.zscan(this._key.getBytes(StandardCharsets.UTF_8), cursor.getBytes(StandardCharsets.UTF_8), p).getResult();
    }

    @Override
    public boolean zsetMatch(String itemPattern) {
        List<Tuple> temp = this.zsetScan(itemPattern, 1);
        return temp != null && temp.size() > 0;
    }

    @Override
    public long geoAdd(double lng, double lat, String member) {
        long tmp = this.cluster.geoadd(this._key, lng, lat, member);
        this.expirePush();
        return tmp;
    }

    @Override
    public long geoAddAll(Map<String, GeoCoordinate> memberMap) {
        long tmp = this.cluster.geoadd(this._key, memberMap);
        this.expirePush();
        return tmp;
    }

    @Override
    public List<GeoRadiusResponse> geoGetByRadius(double centerLng, double centerLat, long radius) {
        return this.cluster.georadius(this._key, centerLng, centerLat, (double)radius, GeoUnit.M);
    }

    @Override
    public long geoDist(String member1, String member2) {
        return this.cluster.geodist(this._key, member1, member2, GeoUnit.M).longValue();
    }

    @Override
    public long publish(String channel, String message) {
        return this.cluster.publish(channel, message);
    }

    @Override
    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        this.cluster.subscribe(jedisPubSub, channels);
    }
}

