/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.binding.impl.AddChannelBindingsHeaderHandler;
import org.opensaml.saml.common.messaging.context.ChannelBindingsContext;
import org.opensaml.saml.ext.saml2cb.ChannelBindings;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Envelope;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddChannelBindingsHeaderHandlerTest
extends OpenSAMLInitBaseTestCase {
    private ChannelBindingsContext cbc;
    private MessageContext messageCtx;
    private AddChannelBindingsHeaderHandler handler;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.messageCtx = new MessageContext();
        ChannelBindings cb = (ChannelBindings)((SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(ChannelBindings.DEFAULT_ELEMENT_NAME)).buildObject();
        cb.setType("foo");
        this.cbc = new ChannelBindingsContext();
        this.cbc.getChannelBindings().add(cb);
        this.handler = new AddChannelBindingsHeaderHandler();
        this.handler.initialize();
    }

    @Test
    public void testNoBindings() throws MessageHandlerException {
        this.handler.invoke(this.messageCtx);
        List headers = SOAPMessagingSupport.getHeaderBlock((MessageContext)this.messageCtx, (QName)ChannelBindings.DEFAULT_ELEMENT_NAME, null, (boolean)true);
        Assert.assertTrue((boolean)headers.isEmpty());
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testMissingEnvelope() throws MessageHandlerException, ComponentInitializationException {
        this.messageCtx.addSubcontext((BaseContext)this.cbc);
        this.handler.invoke(this.messageCtx);
    }

    @Test
    public void testSuccess() throws MessageHandlerException, ComponentInitializationException {
        this.messageCtx.addSubcontext((BaseContext)this.cbc);
        Envelope env = (Envelope)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Envelope.DEFAULT_ELEMENT_NAME).buildObject(Envelope.DEFAULT_ELEMENT_NAME);
        ((SOAP11Context)this.messageCtx.getSubcontext(SOAP11Context.class, true)).setEnvelope(env);
        this.handler.invoke(this.messageCtx);
        List headers = SOAPMessagingSupport.getHeaderBlock((MessageContext)this.messageCtx, (QName)ChannelBindings.DEFAULT_ELEMENT_NAME, null, (boolean)true);
        Assert.assertEquals((int)headers.size(), (int)1);
        Assert.assertEquals((String)((ChannelBindings)headers.get(0)).getType(), (String)"foo");
    }
}

