/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import java.util.Collections;
import java.util.function.Function;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.ParentProfileRequestContextLookup;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.common.binding.impl.PopulateSignatureSigningParametersHandler;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.SignatureSigningParametersResolver;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateSignatureSigningParametersHandlerTest
extends OpenSAMLInitBaseTestCase {
    private ProfileRequestContext prc;
    private PopulateSignatureSigningParametersHandler handler;

    @BeforeMethod
    public void setUp() {
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        this.handler = new PopulateSignatureSigningParametersHandler();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testConfig() throws ComponentInitializationException {
        this.handler.initialize();
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNoContext() throws Exception {
        this.handler.setSignatureSigningParametersResolver((SignatureSigningParametersResolver)new MockResolver(false));
        this.handler.initialize();
        this.prc.setOutboundMessageContext(null);
        this.handler.invoke(this.prc.getOutboundMessageContext());
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testResolverError() throws Exception {
        this.handler.setSignatureSigningParametersResolver((SignatureSigningParametersResolver)new MockResolver(true));
        this.handler.initialize();
        this.handler.invoke(this.prc.getOutboundMessageContext());
    }

    @Test
    public void testSuccess() throws Exception {
        this.handler.setSignatureSigningParametersResolver((SignatureSigningParametersResolver)new MockResolver(false));
        this.handler.initialize();
        this.handler.invoke(this.prc.getOutboundMessageContext());
        Assert.assertNotNull((Object)((SecurityParametersContext)this.prc.getOutboundMessageContext().getSubcontext(SecurityParametersContext.class)).getSignatureSigningParameters());
    }

    @Test
    public void testCopy() throws Exception {
        this.handler.setSignatureSigningParametersResolver((SignatureSigningParametersResolver)new MockResolver(true));
        this.handler.setExistingParametersContextLookupStrategy(new ChildContextLookup(SecurityParametersContext.class).compose((Function)new ParentProfileRequestContextLookup()));
        this.handler.setSecurityParametersContextLookupStrategy((Function)new ChildContextLookup(SecurityParametersContext.class, true));
        this.handler.initialize();
        ((SecurityParametersContext)this.prc.getSubcontext(SecurityParametersContext.class, true)).setSignatureSigningParameters(new SignatureSigningParameters());
        this.handler.invoke(this.prc.getOutboundMessageContext());
        Assert.assertSame((Object)((SecurityParametersContext)this.prc.getSubcontext(SecurityParametersContext.class)).getSignatureSigningParameters(), (Object)((SecurityParametersContext)this.prc.getOutboundMessageContext().getSubcontext(SecurityParametersContext.class)).getSignatureSigningParameters());
    }

    private class MockResolver
    implements SignatureSigningParametersResolver {
        private boolean throwException;

        public MockResolver(boolean shouldThrow) {
            this.throwException = shouldThrow;
        }

        public Iterable<SignatureSigningParameters> resolve(CriteriaSet criteria) throws ResolverException {
            return Collections.singletonList(this.resolveSingle(criteria));
        }

        public SignatureSigningParameters resolveSingle(CriteriaSet criteria) throws ResolverException {
            if (this.throwException) {
                throw new ResolverException();
            }
            Constraint.isNotNull((Object)((SignatureSigningConfigurationCriterion)criteria.get(SignatureSigningConfigurationCriterion.class)), (String)"Criterion was null");
            return new SignatureSigningParameters();
        }
    }
}

