/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security.impl;

import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.binding.security.impl.EndpointURLSchemeSecurityHandler;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.testng.annotations.Test;

public class EndpointURLSchemeSecurityHandlerTest
extends XMLObjectBaseTestCase {
    @Test
    public void testValidRequestLocation() throws MessageHandlerException {
        AssertionConsumerService endpoint = (AssertionConsumerService)this.buildXMLObject(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        endpoint.setLocation("http://idp.example.com/sso");
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)this.buildXMLObject(AuthnRequest.DEFAULT_ELEMENT_NAME));
        ((SAMLEndpointContext)((SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLEndpointContext.class, true)).setEndpoint((Endpoint)endpoint);
        EndpointURLSchemeSecurityHandler handler = new EndpointURLSchemeSecurityHandler();
        handler.invoke(messageContext);
    }

    @Test
    public void testValidResponseLocation() throws MessageHandlerException {
        AssertionConsumerService endpoint = (AssertionConsumerService)this.buildXMLObject(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        endpoint.setResponseLocation("http://sp.example.com/acs");
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)this.buildXMLObject(Response.DEFAULT_ELEMENT_NAME));
        ((SAMLEndpointContext)((SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLEndpointContext.class, true)).setEndpoint((Endpoint)endpoint);
        EndpointURLSchemeSecurityHandler handler = new EndpointURLSchemeSecurityHandler();
        handler.invoke(messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testInvalidRequestLocation() throws MessageHandlerException {
        AssertionConsumerService endpoint = (AssertionConsumerService)this.buildXMLObject(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        endpoint.setLocation("badscheme://idp.example.com/sso");
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)this.buildXMLObject(AuthnRequest.DEFAULT_ELEMENT_NAME));
        ((SAMLEndpointContext)((SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLEndpointContext.class, true)).setEndpoint((Endpoint)endpoint);
        EndpointURLSchemeSecurityHandler handler = new EndpointURLSchemeSecurityHandler();
        handler.invoke(messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testInvalidResponseLocation() throws MessageHandlerException {
        AssertionConsumerService endpoint = (AssertionConsumerService)this.buildXMLObject(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        endpoint.setResponseLocation("badscheme://sp.example.com/acs");
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)this.buildXMLObject(Response.DEFAULT_ELEMENT_NAME));
        ((SAMLEndpointContext)((SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLEndpointContext.class, true)).setEndpoint((Endpoint)endpoint);
        EndpointURLSchemeSecurityHandler handler = new EndpointURLSchemeSecurityHandler();
        handler.invoke(messageContext);
    }
}

