/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security.impl;

import java.time.Duration;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.binding.security.impl.MessageReplaySecurityHandler;
import org.opensaml.saml.common.messaging.context.SAMLMessageInfoContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.storage.ReplayCache;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MessageReplaySecurityHandlerTest
extends XMLObjectBaseTestCase {
    private MessageContext messageContext;
    private MessageReplaySecurityHandler handler;
    private String messageID;
    private MemoryStorageService storageService;
    private ReplayCache replayCache;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.messageContext = new MessageContext();
        this.messageID = "abc123";
        ((SAMLPeerEntityContext)this.messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).setEntityId("issuer");
        ((SAMLMessageInfoContext)this.messageContext.getSubcontext(SAMLMessageInfoContext.class, true)).setMessageId(this.messageID);
        this.storageService = new MemoryStorageService();
        this.storageService.setId("test");
        this.storageService.initialize();
        this.replayCache = new ReplayCache();
        this.replayCache.setStorage((StorageService)this.storageService);
        this.replayCache.initialize();
        this.handler = new MessageReplaySecurityHandler();
        this.handler.setReplayCache(this.replayCache);
        this.handler.initialize();
    }

    @AfterMethod
    protected void tearDown() {
        this.handler = null;
        this.replayCache.destroy();
        this.replayCache = null;
        this.storageService.destroy();
        this.storageService = null;
    }

    @Test
    public void testNoReplay() throws MessageHandlerException {
        this.handler.invoke(this.messageContext);
    }

    @Test
    public void testNoReplayDistinctIDs() throws MessageHandlerException {
        this.handler.invoke(this.messageContext);
        ((SAMLMessageInfoContext)this.messageContext.getSubcontext(SAMLMessageInfoContext.class)).setMessageId("someOther" + this.messageID);
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testReplay() throws MessageHandlerException {
        this.handler.invoke(this.messageContext);
        this.handler.invoke(this.messageContext);
    }

    @Test
    public void testReplayValidWithExpiration() throws InterruptedException, MessageHandlerException, ComponentInitializationException {
        this.handler = new MessageReplaySecurityHandler();
        this.handler.setReplayCache(this.replayCache);
        this.handler.setExpires(Duration.ofSeconds(3L));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        Thread.sleep(4000L);
        this.handler.invoke(this.messageContext);
    }
}

