/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security.impl;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.binding.security.impl.SAMLProtocolMessageXMLSignatureSecurityHandler;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.common.testing.SAMLTestSupport;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.CollectionCredentialResolver;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Support;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SAMLProtocolMessageXMLSignatureSecurityHandlerTest
extends XMLObjectBaseTestCase {
    private MessageContext messageContext;
    private SAMLProtocolMessageXMLSignatureSecurityHandler handler;
    private X509Certificate signingCert;
    private String signingCertBase64 = "MIIDzjCCAragAwIBAgIBMTANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnMB4XDTA3MDUyMTE4MjM0MFoXDTE3MDUxODE4MjM0MFowMTESMBAGA1UEChMJSW50ZXJuZXQyMRswGQYDVQQDExJmb29iYXIuZXhhbXBsZS5vcmcwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDNWnkFmhy1vYa6gN/xBRKkZxFy3sUq2V0LsYb6Q3pe9Qlb6+BzaM5DrN8uIqqroBE3Wp0LtrgKuQTpDpNFBdS2p5afiUtOYLWBDtizTOzs3Z36MGMjIPUYQ4s03IP3yPh2ud6EKpDPiYqzNbkRaiIwmYSit5r+RMYvd6fuKvTOn6h7PZI5AD7Rda7VWh5OVSoZXlRx3qxFho+mZhW0q4fUfTi5lWwf4EhkfBlzgw/k5gf4cOi6rrGpRS1zxmbtX1RAg+I20z6d04g0N2WsK5stszgYKoIROJCiXwjraa8/SoFcILolWQpttVHBIUYlyDlm8mIFleZf4ReFpfm+nUYxAgMBAAGjgfQwgfEwCQYDVR0TBAIwADAsBglghkgBhvhCAQ0EHxYdT3BlblNTTCBHZW5lcmF0ZWQgQ2VydGlmaWNhdGUwHQYDVR0OBBYEFDgRgTkjaKoK6DoZfUZ4g9LDJUWuMFUGA1UdIwROMEyAFNXuZVPeUdqHrULqQW7yr9buRpQLoTGkLzAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnggEBMEAGA1UdEQQ5MDeCEmFzaW1vdi5leGFtcGxlLm9yZ4YbaHR0cDovL2hlaW5sZWluLmV4YW1wbGUub3JnhwQKAQIDMA0GCSqGSIb3DQEBBQUAA4IBAQBLiDMyQ60ldIytVO1GCpp1S1sKJyTF56GVxHh/82hiRFbyPu+2eSl7UcJfH4ZNbAfHL1vDKTRJ9zoD8WRzpOCUtT0IPIA/Ex+8lFzZmujO10j3TMpp8Ii6+auYwi/Tosrfw1YCxF+GI5KO49CfDRr6yxUbMhbTN+ssK4UzFf36UbkeJ3EfDwB0WU70jnlkyO8f97X6mLd5QvRcwlkDMftP4+MB+inTlxDZ/w8NLXQoDW6p/8r91bupXe0xwuyEvow2xjxlzVcux2BZsUZYjBa07ZmNNBtF7WaQqH7l2OBCAdnBhvme5i/e0LK3Ivys+hcVyvCXs5XtFTFWDAVYvzQ6";
    private X509Certificate otherCert1;
    private String otherCert1Base64 = "MIIECTCCAvGgAwIBAgIBMzANBgkqhkiG9w0BAQUFADAtMRIwEAYDVQQKEwlJbnRlcm5ldDIxFzAVBgNVBAMTDmNhLmV4YW1wbGUub3JnMB4XDTA3MDUyNTIwMTYxMVoXDTE3MDUyMjIwMTYxMVowGjEYMBYGA1UEAxMPaWRwLmV4YW1wbGUub3JnMIIBtjCCASsGByqGSM44BAEwggEeAoGBAI+ktw7R9m7TxjaCrT2MHwWNQUAyXPrqbFCcu+DCirr861U6R6W/GyqWdcy8/D1Hh/I1U94POQn5yfqVPpVH2ZRS4OMFndHWaoo9V5LJoXTXHiDYB3W4t9tn0fm7It0n7VoUI5C4y9LG32Hq+UIGF/ktNTmo//mEqLS6aJNdbMFpAhUArmKGh0hcpmjukYArWcMRvipB4CMCgYBuCiCrUaHBRRtqrk0P/Luq0l2M2718GwSGeLPZip06gACDG7IctMrgH1J+ZIjsx6vffi977wnMDiktqacmaobV+SCRW9ijJRdkYpUHmlLvuJGnDPjkvewpbGWJsCabpWEvWdYw3ma8RuHOPj4Jkrdd4VcRaFwox/fPJ7cG6kBydgOBhAACgYBxQIPv9DCsmiMHG1FAxSARX0GcRiELJPJ+MtaStdTrVobNa2jebwc3npLiTvUR4U/CDo1mSZb+Sp/wian8kNZHmGcR6KbtJs9UDsa3V0pbbgpUar4HcxV+NQJBbhn9RGu85g3PDILUrINiUAf26mhPN5Y0paM+HbM68nUf1OLv16OBsjCBrzAJBgNVHRMEAjAAMCwGCWCGSAGG+EIBDQQfFh1PcGVuU1NMIEdlbmVyYXRlZCBDZXJ0aWZpY2F0ZTAdBgNVHQ4EFgQUIHFAEB/3jIIZzJEJ/qdsuI8vN3kwVQYDVR0jBE4wTIAU1e5lU95R2oetQupBbvKv1u5GlAuhMaQvMC0xEjAQBgNVBAoTCUludGVybmV0MjEXMBUGA1UEAxMOY2EuZXhhbXBsZS5vcmeCAQEwDQYJKoZIhvcNAQEFBQADggEBAJt4Q34+pqjW5tHHhkdzTITSBjOOf8EvYMgxTMRzhagLSHTt9RgO5i/G7ELvnwe1j6187m1XD9iEAWKeKbB//ljeOpgnwzkLR9Er5tr1RI3cbil0AX+oX0c1jfRaQnR50Rfb5YoNX6G963iphlxp9C8VLB6eOk/S270XoWoQIkO1ioQ8JY4HE6AyDsOpJaOmHpBaxjgsiko52ZWZeZyaCyL98BXwVxeml7pYnHlXWWidB0N/Zy+LbvWg3urUkiDjMcB6nGImmEfDSxRdybitcMwbwL26z2WOpwL3llm3mcCydKXgXt8IQhfDhOZOHWckeD2tStnJRP/cqBgO62/qirw=";
    private CollectionCredentialResolver credResolver;
    private List<Credential> trustedCredentials;
    private BasicX509Credential signingX509Cred;
    private String issuer;
    private SignatureTrustEngine signatureTrustEngine;
    private SignatureValidationParameters sigValParams;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.issuer = "SomeCoolIssuer";
        this.signingCert = X509Support.decodeCertificate((String)this.signingCertBase64);
        this.signingX509Cred = new BasicX509Credential(this.signingCert);
        this.signingX509Cred.setEntityId(this.issuer);
        this.otherCert1 = X509Support.decodeCertificate((String)this.otherCert1Base64);
        BasicX509Credential otherCred1 = new BasicX509Credential(this.otherCert1);
        otherCred1.setEntityId("other-1");
        this.trustedCredentials = new ArrayList<Credential>();
        this.trustedCredentials.add((Credential)otherCred1);
        this.credResolver = new CollectionCredentialResolver(this.trustedCredentials);
        KeyInfoCredentialResolver kiResolver = SAMLTestSupport.buildBasicInlineKeyInfoResolver();
        this.signatureTrustEngine = new ExplicitKeySignatureTrustEngine((CredentialResolver)this.credResolver, kiResolver);
        this.sigValParams = new SignatureValidationParameters();
        this.sigValParams.setSignatureTrustEngine(this.signatureTrustEngine);
        this.handler = new SAMLProtocolMessageXMLSignatureSecurityHandler();
        this.handler.initialize();
        this.messageContext = new MessageContext();
        this.messageContext.setMessage((Object)this.buildInboundSAMLMessage());
        ((SAMLPeerEntityContext)this.messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).setEntityId(this.issuer);
        ((SAMLPeerEntityContext)this.messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        ((SAMLProtocolContext)this.messageContext.getSubcontext(SAMLProtocolContext.class, true)).setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        ((SecurityParametersContext)this.messageContext.getSubcontext(SecurityParametersContext.class, true)).setSignatureValidationParameters(this.sigValParams);
    }

    @Test
    public void testSuccess() throws MessageHandlerException {
        this.trustedCredentials.add((Credential)this.signingX509Cred);
        this.handler.invoke(this.messageContext);
        Assert.assertEquals((String)((SAMLPeerEntityContext)this.messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getEntityId(), (String)this.issuer, (String)"Unexpected value for Issuer found");
        Assert.assertTrue((boolean)((SAMLPeerEntityContext)this.messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).isAuthenticated(), (String)"Unexpected value for context authentication state");
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testBlacklistedSigntureAlgorithm() throws MessageHandlerException {
        this.sigValParams.setExcludedAlgorithms(Collections.singleton("http://www.w3.org/2000/09/xmldsig#rsa-sha1"));
        this.trustedCredentials.add((Credential)this.signingX509Cred);
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testUntrustedCredential() throws MessageHandlerException {
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testInvalidSignature() throws MessageHandlerException {
        this.trustedCredentials.add((Credential)this.signingX509Cred);
        AuthnRequest request = (AuthnRequest)this.unmarshallElement("/org/opensaml/saml/common/binding/security/Signed-AuthnRequest-InvalidSignature.xml");
        this.messageContext.setMessage((Object)request);
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testNoContextIssuer() throws MessageHandlerException {
        this.messageContext.removeSubcontext(SAMLPeerEntityContext.class);
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testNoTrustEngine() throws MessageHandlerException {
        this.messageContext.removeSubcontext(SecurityParametersContext.class);
        this.handler.invoke(this.messageContext);
    }

    protected AuthnRequest buildInboundSAMLMessage() {
        AuthnRequest request = (AuthnRequest)this.unmarshallElement("/org/opensaml/saml/common/binding/security/Signed-AuthnRequest.xml");
        return request;
    }
}

