/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.impl;

import java.util.List;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.profile.impl.AddAudienceRestrictionToAssertions;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.testing.SAML1ActionTestingSupport;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddAudienceRestrictionToAssertionsTest
extends OpenSAMLInitBaseTestCase {
    private static final String AUDIENCE1 = "foo";
    private static final String AUDIENCE2 = "foo2";
    private AddAudienceRestrictionToAssertions action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.action = new AddAudienceRestrictionToAssertions();
        this.action.setAudienceRestrictionsLookupStrategy(FunctionSupport.constant(List.of(AUDIENCE1, AUDIENCE2)));
        this.action.initialize();
    }

    @Test
    public void testNoResponse() throws Exception {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoAssertion() throws Exception {
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)SAML1ActionTestingSupport.buildResponse()).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
    }

    @Test
    public void testSingleAssertion() throws Exception {
        Assertion assertion = SAML1ActionTestingSupport.buildAssertion();
        Response response = SAML1ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertEquals((int)assertion.getConditions().getAudienceRestrictionConditions().size(), (int)1);
        AudienceRestrictionCondition audcond = (AudienceRestrictionCondition)assertion.getConditions().getAudienceRestrictionConditions().get(0);
        Assert.assertEquals((int)audcond.getAudiences().size(), (int)2);
        Assert.assertEquals((String)((org.opensaml.saml.saml1.core.Audience)audcond.getAudiences().get(0)).getURI(), (String)AUDIENCE1);
        Assert.assertEquals((String)((org.opensaml.saml.saml1.core.Audience)audcond.getAudiences().get(1)).getURI(), (String)AUDIENCE2);
    }

    @Test
    public void testSingleAssertionWithExistingCondition() throws Exception {
        SAMLObjectBuilder conditionsBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Conditions.DEFAULT_ELEMENT_NAME);
        Conditions conditions = (Conditions)conditionsBuilder.buildObject();
        Assertion assertion = SAML1ActionTestingSupport.buildAssertion();
        assertion.setConditions(conditions);
        Response response = SAML1ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertEquals((int)assertion.getConditions().getAudienceRestrictionConditions().size(), (int)1);
        AudienceRestrictionCondition audcond = (AudienceRestrictionCondition)assertion.getConditions().getAudienceRestrictionConditions().get(0);
        Assert.assertEquals((int)audcond.getAudiences().size(), (int)2);
        Assert.assertEquals((String)((org.opensaml.saml.saml1.core.Audience)audcond.getAudiences().get(0)).getURI(), (String)AUDIENCE1);
        Assert.assertEquals((String)((org.opensaml.saml.saml1.core.Audience)audcond.getAudiences().get(1)).getURI(), (String)AUDIENCE2);
    }

    @Test
    public void testSingleAssertionWithExistingAudienceCondition() throws Exception {
        SAMLObjectBuilder conditionBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AudienceRestrictionCondition.DEFAULT_ELEMENT_NAME);
        AudienceRestrictionCondition condition = (AudienceRestrictionCondition)conditionBuilder.buildObject();
        SAMLObjectBuilder conditionsBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Conditions.DEFAULT_ELEMENT_NAME);
        Conditions conditions = (Conditions)conditionsBuilder.buildObject();
        conditions.getAudienceRestrictionConditions().add(condition);
        Assertion assertion = SAML1ActionTestingSupport.buildAssertion();
        assertion.setConditions(conditions);
        Response response = SAML1ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertEquals((int)assertion.getConditions().getAudienceRestrictionConditions().size(), (int)1);
        AudienceRestrictionCondition audcond = (AudienceRestrictionCondition)assertion.getConditions().getAudienceRestrictionConditions().get(0);
        Assert.assertEquals((int)audcond.getAudiences().size(), (int)2);
        Assert.assertEquals((String)((org.opensaml.saml.saml1.core.Audience)audcond.getAudiences().get(0)).getURI(), (String)AUDIENCE1);
        Assert.assertEquals((String)((org.opensaml.saml.saml1.core.Audience)audcond.getAudiences().get(1)).getURI(), (String)AUDIENCE2);
    }

    @Test
    public void testMultipleAssertion() throws Exception {
        Response response = SAML1ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)3);
        for (Assertion assertion : response.getAssertions()) {
            Assert.assertNotNull((Object)assertion.getConditions());
            Assert.assertEquals((int)assertion.getConditions().getAudienceRestrictionConditions().size(), (int)1);
            AudienceRestrictionCondition audcond = (AudienceRestrictionCondition)assertion.getConditions().getAudienceRestrictionConditions().get(0);
            Assert.assertEquals((int)audcond.getAudiences().size(), (int)2);
            Assert.assertEquals((String)((org.opensaml.saml.saml1.core.Audience)audcond.getAudiences().get(0)).getURI(), (String)AUDIENCE1);
            Assert.assertEquals((String)((org.opensaml.saml.saml1.core.Audience)audcond.getAudiences().get(1)).getURI(), (String)AUDIENCE2);
        }
    }

    @Test
    public void testSAML2Assertion() throws Exception {
        org.opensaml.saml.saml2.core.Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        org.opensaml.saml.saml2.core.Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertEquals((int)assertion.getConditions().getAudienceRestrictions().size(), (int)1);
        AudienceRestriction audcond = (AudienceRestriction)assertion.getConditions().getAudienceRestrictions().get(0);
        Assert.assertEquals((int)audcond.getAudiences().size(), (int)2);
        Assert.assertEquals((String)((Audience)audcond.getAudiences().get(0)).getURI(), (String)AUDIENCE1);
        Assert.assertEquals((String)((Audience)audcond.getAudiences().get(1)).getURI(), (String)AUDIENCE2);
    }
}

