/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.saml2cb.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.ext.saml2cb.ChannelBindings;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ChannelBindingsTest
extends XMLObjectProviderBaseTestCase {
    private String expectedContent;
    private String expectedSOAP11Actor;
    private Boolean expectedSOAP11MustUnderstand;

    public ChannelBindingsTest() {
        this.singleElementFile = "/org/opensaml/saml/ext/saml2cb/impl/ChannelBindings.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedContent = "YourChannelIsBound";
        this.expectedSOAP11Actor = "https://soap11actor.example.org";
        this.expectedSOAP11MustUnderstand = true;
    }

    @Test
    public void testSingleElementUnmarshall() {
        ChannelBindings cb = (ChannelBindings)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)cb);
        Assert.assertEquals((Object)this.expectedSOAP11MustUnderstand, (Object)cb.isSOAP11MustUnderstand(), (String)"SOAP mustUnderstand had unxpected value");
        Assert.assertEquals((String)this.expectedSOAP11Actor, (String)cb.getSOAP11Actor(), (String)"SOAP actor had unxpected value");
        Assert.assertEquals((String)this.expectedContent, (String)cb.getValue(), (String)"Element content had unexpected value");
    }

    @Test
    public void testSingleElementMarshall() {
        ChannelBindings cb = (ChannelBindings)this.buildXMLObject(ChannelBindings.DEFAULT_ELEMENT_NAME);
        cb.setSOAP11Actor(this.expectedSOAP11Actor);
        cb.setSOAP11MustUnderstand(this.expectedSOAP11MustUnderstand);
        cb.setValue(this.expectedContent);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)cb);
    }
}

