/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.saml2delrestrict.impl;

import java.time.Instant;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.ext.saml2delrestrict.Delegate;
import org.opensaml.saml.saml2.core.NameID;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DelegateTest
extends XMLObjectProviderBaseTestCase {
    private Instant expectedDelegationInstant;
    private String expectedConfirmationMethod;

    public DelegateTest() {
        this.singleElementFile = "/org/opensaml/saml/ext/saml2delrestrict/impl/Delegate.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/ext/saml2delrestrict/impl/DelegateOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/ext/saml2delrestrict/impl/DelegateChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedDelegationInstant = Instant.parse("1984-08-26T10:01:30.043Z");
        this.expectedConfirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
    }

    @Test
    public void testSingleElementUnmarshall() {
        Delegate delegate = (Delegate)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)delegate);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        Delegate delegate = (Delegate)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)delegate);
        Instant instant = delegate.getDelegationInstant();
        Assert.assertEquals((Object)instant, (Object)this.expectedDelegationInstant, (String)"DelegationInstant was unexpected value");
        String cm = delegate.getConfirmationMethod();
        Assert.assertEquals((String)cm, (String)this.expectedConfirmationMethod, (String)"ConfirmationMethod was unexpected value");
    }

    @Test
    public void testChildElementsUnmarshall() {
        Delegate delegate = (Delegate)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)delegate);
        Assert.assertNotNull((Object)delegate.getNameID(), (String)"NameID was null");
        Assert.assertNull((Object)delegate.getBaseID(), (String)"BaseID was non-null");
        Assert.assertNull((Object)delegate.getEncryptedID(), (String)"EncryptedID was non-null");
    }

    @Test
    public void testSingleElementMarshall() {
        Delegate delegate = (Delegate)this.buildXMLObject(Delegate.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)delegate);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        Delegate delegate = (Delegate)this.buildXMLObject(Delegate.DEFAULT_ELEMENT_NAME);
        delegate.setConfirmationMethod(this.expectedConfirmationMethod);
        delegate.setDelegationInstant(this.expectedDelegationInstant);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)delegate);
    }

    @Test
    public void testChildElementsMarshall() {
        Delegate delegate = (Delegate)this.buildXMLObject(Delegate.DEFAULT_ELEMENT_NAME);
        delegate.setNameID((NameID)this.buildXMLObject(NameID.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)delegate);
    }
}

