/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.saml2mdrpi.impl;

import java.time.Instant;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.ext.saml2mdrpi.Publication;
import org.testng.Assert;

public class PublicationTest
extends XMLObjectProviderBaseTestCase {
    private static String expectedPublisher = "publisher";
    private static String expectedPublicationId = "Ident";
    private static Instant expectedCreationInstant = Instant.parse("2010-08-11T14:59:01.002Z");

    public PublicationTest() {
        this.singleElementFile = "/org/opensaml/saml/ext/saml2mdrpi/Publication.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/ext/saml2mdrpi/PublicationOptionalAttr.xml";
    }

    public void testSingleElementUnmarshall() {
        Publication info = (Publication)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)info.getPublisher(), (String)expectedPublisher);
    }

    public void testSingleElementOptionalAttributesUnmarshall() {
        Publication info = (Publication)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)info.getPublisher(), (String)expectedPublisher);
        Assert.assertEquals((String)info.getPublicationId(), (String)expectedPublicationId);
        Assert.assertEquals((Object)info.getCreationInstant(), (Object)expectedCreationInstant);
    }

    public void testSingleElementMarshall() {
        Publication info = (Publication)this.buildXMLObject(Publication.DEFAULT_ELEMENT_NAME);
        info.setPublisher(expectedPublisher);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)info);
    }

    public void testSingleElementOptionalAttributesMarshall() {
        Publication info = (Publication)this.buildXMLObject(Publication.DEFAULT_ELEMENT_NAME);
        info.setPublisher(expectedPublisher);
        info.setCreationInstant(expectedCreationInstant);
        info.setPublicationId(expectedPublicationId);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)info);
    }
}

