/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.MockFailureFilter;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class DOMMetadataResolverTest
extends XMLObjectBaseTestCase {
    private DOMMetadataResolver metadataProvider;
    private File mdFile;
    private String entityID;
    private CriteriaSet criteriaSet;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.entityID = "urn:mace:incommon:washington.edu";
        URL mdURL = DOMMetadataResolverTest.class.getResource("/org/opensaml/saml/saml2/metadata/InCommon-metadata.xml");
        this.mdFile = new File(mdURL.toURI());
        try (FileInputStream fis = new FileInputStream(this.mdFile);){
            Document document = parserPool.parse((InputStream)fis);
            this.metadataProvider = new DOMMetadataResolver(document.getDocumentElement());
        }
        this.metadataProvider.setId("test");
        this.metadataProvider.initialize();
        this.criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.entityID)});
    }

    @Test
    public void testGetEntityDescriptor() throws ResolverException {
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test
    public void testFilterFailureAndNoFailFast() throws URISyntaxException, XMLParserException, IOException, ResolverException {
        try (FileInputStream fis = new FileInputStream(this.mdFile);){
            Document document = parserPool.parse((InputStream)fis);
            this.metadataProvider = new DOMMetadataResolver(document.getDocumentElement());
            this.metadataProvider.setMetadataFilter((MetadataFilter)new MockFailureFilter());
            this.metadataProvider.setFailFastInitialization(false);
            this.metadataProvider.setRequireValidMetadata(true);
            this.metadataProvider.setParserPool(parserPool);
            this.metadataProvider.setId("test");
            this.metadataProvider.initialize();
        }
        catch (ComponentInitializationException e) {
            Assert.fail((String)"DOM metadata provider init failed due to filter exception and fail fast = false");
        }
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp.example.org")}));
        Assert.assertNull((Object)entity);
    }
}

