/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.metadata.resolver.impl.HTTPEntityIDRequestURLBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HTTPEntityIDRequestURLBuilderTest {
    private HTTPEntityIDRequestURLBuilder function = new HTTPEntityIDRequestURLBuilder();

    @Test
    public void testHTTP() {
        Assert.assertEquals((String)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("http://www.example.com/sp")})), (String)"http://www.example.com/sp");
        Assert.assertEquals((String)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://www.example.com/sp")})), (String)"https://www.example.com/sp");
        Assert.assertEquals((String)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("HTTP://www.example.com/sp")})), (String)"HTTP://www.example.com/sp");
        Assert.assertEquals((String)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("HTTPS://www.example.com/sp")})), (String)"HTTPS://www.example.com/sp");
    }

    @Test
    public void testNonHTTP() {
        Assert.assertNull((Object)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("urn:test:sp")})));
        Assert.assertNull((Object)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("foo")})));
        Assert.assertNull((Object)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("httpblah://not.a.url.com")})));
        Assert.assertNull((Object)this.function.apply(new CriteriaSet()));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullEntityID() {
        this.function.apply(null);
    }
}

