/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.ext.saml2mdquery.AttributeQueryDescriptorType;
import org.opensaml.saml.metadata.criteria.role.EvaluableRoleDescriptorCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.impl.PredicateRoleDescriptorResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.testng.collections.Lists;

public class PredicateRoleDescriptorResolverTest
extends XMLObjectBaseTestCase {
    @Test
    public void testNoEntitiesResolveSingle() throws ResolverException, ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)new StaticMetadataResolver(Lists.newArrayList()));
        roleResolver.initialize();
        RoleDescriptor roleDescriptor = roleResolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME)}));
        Assert.assertNull((Object)roleDescriptor, (String)"Resolved RoleDescriptor was null");
    }

    @Test
    public void testNoEntitiesResolveMulti() throws ResolverException, ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)new StaticMetadataResolver(Lists.newArrayList()));
        roleResolver.initialize();
        Iterable roleDescriptors = roleResolver.resolve(new CriteriaSet(new Criterion[]{new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME)}));
        Assert.assertNotNull((Object)roleDescriptors, (String)"Resolved RoleDescriptor iterable was null");
        Assert.assertFalse((boolean)roleDescriptors.iterator().hasNext());
    }

    @Test
    public void testSingleEntityResolveSingleNoProtocol() throws ResolverException, ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)new StaticMetadataResolver(Lists.newArrayList((Object[])new EntityDescriptor[]{this.buildTestDescriptor()})));
        roleResolver.initialize();
        RoleDescriptor roleDescriptor = roleResolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME)}));
        Assert.assertNotNull((Object)roleDescriptor, (String)"Resolved RoleDescriptor was null");
        Assert.assertEquals((Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME, (Object)roleDescriptor.getElementQName(), (String)"Saw incorrect role type");
    }

    @Test
    public void testSingleEntityResolveSingleWithFalsePredicate() throws ResolverException, ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)new StaticMetadataResolver(Lists.newArrayList((Object[])new EntityDescriptor[]{this.buildTestDescriptor()})));
        roleResolver.initialize();
        RoleDescriptor roleDescriptor = roleResolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new BooleanPredicateCriterion(false)}));
        Assert.assertNull((Object)roleDescriptor, (String)"Resolved RoleDescriptor was not null");
    }

    @Test
    public void testSingleEntityResolveMultiNoProtocol() throws ResolverException, ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)new StaticMetadataResolver(Lists.newArrayList((Object[])new EntityDescriptor[]{this.buildTestDescriptor()})));
        roleResolver.initialize();
        Iterable roleDescriptors = roleResolver.resolve(new CriteriaSet(new Criterion[]{new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME)}));
        Assert.assertNotNull((Object)roleDescriptors, (String)"Resolved RoleDescriptor iterable was null");
        int count = 0;
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            Assert.assertEquals((Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME, (Object)roleDescriptor.getElementQName(), (String)"Saw incorrect role type");
            ++count;
        }
        Assert.assertEquals((int)2, (int)count, (String)"Resolved unexpected number of RoleDescriptors");
    }

    @Test
    public void testSingleEntityResolveMultiWithFalsePredicate() throws ResolverException, ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)new StaticMetadataResolver(Lists.newArrayList((Object[])new EntityDescriptor[]{this.buildTestDescriptor()})));
        roleResolver.initialize();
        Iterable roleDescriptors = roleResolver.resolve(new CriteriaSet(new Criterion[]{new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new BooleanPredicateCriterion(false)}));
        Assert.assertNotNull((Object)roleDescriptors, (String)"Resolved RoleDescriptor iterable was null");
        int count = 0;
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            Assert.assertEquals((Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME, (Object)roleDescriptor.getElementQName(), (String)"Saw incorrect role type");
            ++count;
        }
        Assert.assertEquals((int)0, (int)count, (String)"Resolved unexpected number of RoleDescriptors");
    }

    @Test
    public void testSingleEntityResolveSingleWithProtocol() throws ResolverException, ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)new StaticMetadataResolver(Lists.newArrayList((Object[])new EntityDescriptor[]{this.buildTestDescriptor()})));
        roleResolver.initialize();
        RoleDescriptor roleDescriptor = roleResolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol")}));
        Assert.assertNotNull((Object)roleDescriptor, (String)"Resolved RoleDescriptor was null");
        Assert.assertEquals((Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME, (Object)roleDescriptor.getElementQName(), (String)"Saw incorrect role type");
        Assert.assertTrue((boolean)roleDescriptor.getSupportedProtocols().contains("urn:oasis:names:tc:SAML:2.0:protocol"), (String)"Returned RoleDescriptor didn't support specified protocol");
    }

    @Test
    public void testSingleEntityResolveMultiWithProtocol() throws ResolverException, ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)new StaticMetadataResolver(Lists.newArrayList((Object[])new EntityDescriptor[]{this.buildTestDescriptor()})));
        roleResolver.initialize();
        Iterable roleDescriptors = roleResolver.resolve(new CriteriaSet(new Criterion[]{new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol")}));
        Assert.assertNotNull((Object)roleDescriptors, (String)"Resolved RoleDescriptor iterable was null");
        int count = 0;
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            Assert.assertEquals((Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME, (Object)roleDescriptor.getElementQName(), (String)"Saw incorrect role type");
            Assert.assertTrue((boolean)roleDescriptor.getSupportedProtocols().contains("urn:oasis:names:tc:SAML:2.0:protocol"), (String)"Returned RoleDescriptor didn't support specified protocol");
            ++count;
        }
        Assert.assertEquals((int)1, (int)count, (String)"Resolved unexpected number of RoleDescriptors");
    }

    @Test
    public void testSingleEntityResolveMultiNoRoleCriteria() throws ResolverException, ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)new StaticMetadataResolver(Lists.newArrayList((Object[])new EntityDescriptor[]{this.buildTestDescriptor()})));
        roleResolver.initialize();
        Iterable roleDescriptors = roleResolver.resolve(new CriteriaSet());
        Assert.assertNotNull((Object)roleDescriptors, (String)"Resolved RoleDescriptor iterable was null");
        int count = 0;
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            Assert.assertEquals((Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME, (Object)roleDescriptor.getElementQName(), (String)"Saw incorrect role type");
            ++count;
        }
        Assert.assertEquals((int)0, (int)count, (String)"Resolved unexpected number of RoleDescriptors");
    }

    @Test
    public void testSingleEntityResolveMultiNoRoleCriteriaWithFalsePredicate() throws ResolverException, ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)new StaticMetadataResolver(Lists.newArrayList((Object[])new EntityDescriptor[]{this.buildTestDescriptor()})));
        roleResolver.setResolveViaPredicatesOnly(true);
        roleResolver.initialize();
        Iterable roleDescriptors = roleResolver.resolve(new CriteriaSet(new Criterion[]{new BooleanPredicateCriterion(false)}));
        Assert.assertNotNull((Object)roleDescriptors, (String)"Resolved RoleDescriptor iterable was null");
        int count = 0;
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            ++count;
        }
        Assert.assertEquals((int)0, (int)count, (String)"Resolved unexpected number of RoleDescriptors");
    }

    @Test
    public void testSingleEntityResolveMultiNoRoleCriteriaWithTruePredicate() throws ResolverException, ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)new StaticMetadataResolver(Lists.newArrayList((Object[])new EntityDescriptor[]{this.buildTestDescriptor()})));
        roleResolver.setResolveViaPredicatesOnly(true);
        roleResolver.initialize();
        Iterable roleDescriptors = roleResolver.resolve(new CriteriaSet(new Criterion[]{new BooleanPredicateCriterion(true)}));
        Assert.assertNotNull((Object)roleDescriptors, (String)"Resolved RoleDescriptor iterable was null");
        int count = 0;
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            ++count;
        }
        Assert.assertEquals((int)3, (int)count, (String)"Resolved unexpected number of RoleDescriptors");
    }

    @Test
    public void testMultiEntityResolveSingleWithProtocol() throws ResolverException, ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)new StaticMetadataResolver(Lists.newArrayList((Object[])new EntityDescriptor[]{this.buildTestDescriptor(), this.buildTestDescriptor()})));
        roleResolver.initialize();
        RoleDescriptor roleDescriptor = roleResolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol")}));
        Assert.assertNotNull((Object)roleDescriptor, (String)"Resolved RoleDescriptor was null");
        Assert.assertEquals((Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME, (Object)roleDescriptor.getElementQName(), (String)"Saw incorrect role type");
        Assert.assertTrue((boolean)roleDescriptor.getSupportedProtocols().contains("urn:oasis:names:tc:SAML:2.0:protocol"), (String)"Returned RoleDescriptor didn't support specified protocol");
    }

    @Test
    public void testMultiEntityResolveMultiWithProtocol() throws ResolverException, ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)new StaticMetadataResolver(Lists.newArrayList((Object[])new EntityDescriptor[]{this.buildTestDescriptor(), this.buildTestDescriptor()})));
        roleResolver.initialize();
        Iterable roleDescriptors = roleResolver.resolve(new CriteriaSet(new Criterion[]{new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME), new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol")}));
        Assert.assertNotNull((Object)roleDescriptors, (String)"Resolved RoleDescriptor iterable was null");
        int count = 0;
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            Assert.assertEquals((Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME, (Object)roleDescriptor.getElementQName(), (String)"Saw incorrect role type");
            Assert.assertTrue((boolean)roleDescriptor.getSupportedProtocols().contains("urn:oasis:names:tc:SAML:2.0:protocol"), (String)"Returned RoleDescriptor didn't support specified protocol");
            ++count;
        }
        Assert.assertEquals((int)2, (int)count, (String)"Resolved unexpected number of RoleDescriptors");
    }

    @Test
    public void testMultiEntityResolveSingleNoProtocol() throws ResolverException, ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)new StaticMetadataResolver(Lists.newArrayList((Object[])new EntityDescriptor[]{this.buildTestDescriptor(), this.buildTestDescriptor()})));
        roleResolver.initialize();
        RoleDescriptor roleDescriptor = roleResolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME)}));
        Assert.assertNotNull((Object)roleDescriptor, (String)"Resolved RoleDescriptor was null");
        Assert.assertEquals((Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME, (Object)roleDescriptor.getElementQName(), (String)"Saw incorrect role type");
    }

    @Test
    public void testMultiEntityResolveMultiNoProtocol() throws ResolverException, ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)new StaticMetadataResolver(Lists.newArrayList((Object[])new EntityDescriptor[]{this.buildTestDescriptor(), this.buildTestDescriptor()})));
        roleResolver.initialize();
        Iterable roleDescriptors = roleResolver.resolve(new CriteriaSet(new Criterion[]{new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME)}));
        Assert.assertNotNull((Object)roleDescriptors, (String)"Resolved RoleDescriptor iterable was null");
        int count = 0;
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            Assert.assertEquals((Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME, (Object)roleDescriptor.getElementQName(), (String)"Saw incorrect role type");
            ++count;
        }
        Assert.assertEquals((int)4, (int)count, (String)"Resolved unexpected number of RoleDescriptors");
    }

    @Test
    public void testMultiEntityResolveMultiNoRoleCriteria() throws ResolverException, ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)new StaticMetadataResolver(Lists.newArrayList((Object[])new EntityDescriptor[]{this.buildTestDescriptor(), this.buildTestDescriptor()})));
        roleResolver.initialize();
        Iterable roleDescriptors = roleResolver.resolve(new CriteriaSet(new Criterion[]{new BooleanPredicateCriterion(true)}));
        Assert.assertNotNull((Object)roleDescriptors, (String)"Resolved RoleDescriptor iterable was null");
        int count = 0;
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            Assert.assertEquals((Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME, (Object)roleDescriptor.getElementQName(), (String)"Saw incorrect role type");
            ++count;
        }
        Assert.assertEquals((int)0, (int)count, (String)"Resolved unexpected number of RoleDescriptors");
    }

    @Test
    public void testMultiEntityResolveMultiNoRoleCriteriaWithFalsePredicate() throws ResolverException, ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)new StaticMetadataResolver(Lists.newArrayList((Object[])new EntityDescriptor[]{this.buildTestDescriptor(), this.buildTestDescriptor()})));
        roleResolver.setResolveViaPredicatesOnly(true);
        roleResolver.initialize();
        Iterable roleDescriptors = roleResolver.resolve(new CriteriaSet(new Criterion[]{new BooleanPredicateCriterion(false)}));
        Assert.assertNotNull((Object)roleDescriptors, (String)"Resolved RoleDescriptor iterable was null");
        int count = 0;
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            ++count;
        }
        Assert.assertEquals((int)0, (int)count, (String)"Resolved unexpected number of RoleDescriptors");
    }

    @Test
    public void testMultiEntityResolveMultiNoRoleCriteriaWithTruePredicate() throws ResolverException, ComponentInitializationException {
        PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver((MetadataResolver)new StaticMetadataResolver(Lists.newArrayList((Object[])new EntityDescriptor[]{this.buildTestDescriptor(), this.buildTestDescriptor()})));
        roleResolver.setResolveViaPredicatesOnly(true);
        roleResolver.initialize();
        Iterable roleDescriptors = roleResolver.resolve(new CriteriaSet(new Criterion[]{new BooleanPredicateCriterion(true)}));
        Assert.assertNotNull((Object)roleDescriptors, (String)"Resolved RoleDescriptor iterable was null");
        int count = 0;
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            ++count;
        }
        Assert.assertEquals((int)6, (int)count, (String)"Resolved unexpected number of RoleDescriptors");
    }

    private EntityDescriptor buildTestDescriptor() {
        EntityDescriptor entityDescriptor = (EntityDescriptor)this.buildXMLObject(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        SPSSODescriptor spssoDescriptor1 = (SPSSODescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        spssoDescriptor1.addSupportedProtocol("urn:oasis:names:tc:SAML:1.1:protocol");
        entityDescriptor.getRoleDescriptors().add(spssoDescriptor1);
        AttributeQueryDescriptorType aqDescriptor = (AttributeQueryDescriptorType)this.buildXMLObject(AttributeQueryDescriptorType.TYPE_NAME);
        aqDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        entityDescriptor.getRoleDescriptors().add(aqDescriptor);
        SPSSODescriptor spssoDescriptor2 = (SPSSODescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        spssoDescriptor2.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        entityDescriptor.getRoleDescriptors().add(spssoDescriptor2);
        return entityDescriptor;
    }

    public static class StaticMetadataResolver
    implements MetadataResolver {
        private List<EntityDescriptor> entityDescriptors;

        public StaticMetadataResolver(List<EntityDescriptor> descriptors) {
            this.entityDescriptors = descriptors;
        }

        @Nullable
        public String getId() {
            return "foo";
        }

        @Nullable
        public EntityDescriptor resolveSingle(CriteriaSet criteria) throws ResolverException {
            return this.entityDescriptors.get(0);
        }

        @Nonnull
        public Iterable<EntityDescriptor> resolve(CriteriaSet criteria) throws ResolverException {
            return this.entityDescriptors;
        }

        public boolean isRequireValidMetadata() {
            return false;
        }

        public void setRequireValidMetadata(boolean requireValidMetadata) {
        }

        public MetadataFilter getMetadataFilter() {
            return null;
        }

        public void setMetadataFilter(MetadataFilter newFilter) {
        }
    }

    public static class BooleanPredicateCriterion
    implements EvaluableRoleDescriptorCriterion {
        private boolean result;

        public BooleanPredicateCriterion(boolean flag) {
            this.result = flag;
        }

        public boolean test(RoleDescriptor input) {
            return this.result;
        }
    }
}

