/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.util.function.Function;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.velocity.VelocityEngine;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.metadata.resolver.impl.TemplateRequestURLBuilder;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TemplateRequestURLBuilderTest {
    private org.apache.velocity.app.VelocityEngine engine;
    private TemplateRequestURLBuilder function;

    @BeforeClass
    public void setUp() {
        this.engine = VelocityEngine.newVelocityEngine();
    }

    @Test
    public void testEncodedQueryParam() {
        this.function = new TemplateRequestURLBuilder(this.engine, "http://metadata.example.org/?entity=${entityID}", TemplateRequestURLBuilder.EncodingStyle.form);
        Assert.assertEquals((String)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("http://example.org/idp")})), (String)"http://metadata.example.org/?entity=http%3A%2F%2Fexample.org%2Fidp");
    }

    @Test
    public void testEncodedPath() {
        this.function = new TemplateRequestURLBuilder(this.engine, "http://metadata.example.org/entities/${entityID}", TemplateRequestURLBuilder.EncodingStyle.path);
        Assert.assertEquals((String)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("http://example.org/idp")})), (String)"http://metadata.example.org/entities/http:%2F%2Fexample.org%2Fidp");
    }

    @Test
    public void testEncodedFragment() {
        this.function = new TemplateRequestURLBuilder(this.engine, "http://metadata.example.org/entities#${entityID}", TemplateRequestURLBuilder.EncodingStyle.fragment);
        Assert.assertEquals((String)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("http://example.org/idp")})), (String)"http://metadata.example.org/entities#http://example.org/idp");
    }

    @Test
    public void testWellKnownLocationStyle() {
        this.function = new TemplateRequestURLBuilder(this.engine, "${entityID}", TemplateRequestURLBuilder.EncodingStyle.none);
        Assert.assertEquals((String)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("http://example.org/idp")})), (String)"http://example.org/idp");
    }

    @Test
    public void testTransformer() {
        Function<String, String> transformer = String::toUpperCase;
        this.function = new TemplateRequestURLBuilder(this.engine, "${entityID}", TemplateRequestURLBuilder.EncodingStyle.none, transformer);
        Assert.assertEquals((String)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("http://example.org/idp")})), (String)"HTTP://EXAMPLE.ORG/IDP");
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullEntityID() {
        this.function = new TemplateRequestURLBuilder(this.engine, "http://metadata.example.org/?entity=${entityID}", TemplateRequestURLBuilder.EncodingStyle.form);
        this.function.apply(null);
    }
}

